/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.maven.plugin;

import io.helidon.build.common.maven.MavenModel;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public record MavenArtifact(String groupId, String artifactId, String version, String classifier, String type, Path file) {
    public MavenArtifact(String groupId, String artifactId, String version, String classifier, String type) {
        this(groupId, artifactId, version, classifier, type, null);
    }

    public MavenArtifact(Artifact a) {
        this(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getClassifier(), a.getExtension(), a.getFile() != null ? a.getFile().toPath() : null);
    }

    public MavenArtifact(org.apache.maven.artifact.Artifact a) {
        this(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getClassifier(), a.getType(), a.getFile() != null ? a.getFile().toPath() : null);
    }

    public MavenArtifact(Dependency d) {
        this(d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getClassifier(), d.getType());
    }

    public MavenArtifact(Dependency d, Supplier<String> supplier) {
        this(d.getGroupId(), d.getArtifactId(), d.getVersion() == null ? supplier.get() : d.getVersion(), d.getClassifier(), d.getType());
    }

    public MavenArtifact(Plugin p) {
        this(p.getGroupId(), p.getArtifactId(), p.getVersion(), null, "jar");
    }

    public MavenArtifact(Plugin p, Supplier<String> supplier) {
        this(p.getGroupId(), p.getArtifactId(), p.getVersion() == null ? supplier.get() : p.getVersion(), null, "jar");
    }

    public MavenArtifact(MavenModel m) {
        this(m.groupId(), m.artifactId(), m.version(), null, "jar");
    }

    public Artifact toAetherArtifact() {
        return new DefaultArtifact(this.groupId, this.artifactId, this.classifier, this.type, this.version);
    }

    public MavenArtifact pom() {
        return new MavenArtifact(this.groupId, this.artifactId, this.version, null, "pom");
    }

    public MavenArtifact sourcesJar() {
        return new MavenArtifact(this.groupId, this.artifactId, this.version, "sources", "jar");
    }

    @Override
    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version + ":" + (this.classifier == null ? "" : this.classifier) + ":" + this.type;
    }
}

