/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.maven;

import io.helidon.build.common.Strings;
import io.helidon.build.common.xml.XMLParser;
import io.helidon.build.common.xml.XMLReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.Map;

public final class MavenModel {
    private final Parent parent;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String name;
    private final String description;
    private final String packaging;

    private MavenModel(ModelReader reader) {
        this.parent = reader.hasParent ? new Parent(reader.parentGroupId, reader.parentArtifactId, reader.parentVersion) : null;
        String groupId = Strings.isValid((String)reader.groupId) ? reader.groupId : reader.parentGroupId;
        this.groupId = Strings.requireValid((String)groupId, (String)"groupId is not valid");
        this.artifactId = Strings.requireValid((String)reader.artifactId, (String)"artifactId is not valid");
        String version = Strings.isValid((String)reader.version) ? reader.version : reader.parentVersion;
        this.version = Strings.requireValid((String)version, (String)"version is not valid");
        this.name = reader.name;
        this.description = reader.description;
        String packaging = Strings.isValid((String)reader.packaging) ? reader.packaging : "jar";
        this.packaging = Strings.requireValid((String)packaging, (String)"packaging is not valid");
    }

    public static MavenModel read(Path pomFile) {
        try {
            return MavenModel.read(Files.newInputStream(pomFile, new OpenOption[0]));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static MavenModel read(InputStream is) {
        ModelReader reader = new ModelReader();
        try {
            XMLParser.parse((InputStream)is, (XMLReader)reader);
            return new MavenModel(reader);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public Parent parent() {
        return this.parent;
    }

    public String groupId() {
        return this.groupId;
    }

    public String artifactId() {
        return this.artifactId;
    }

    public String version() {
        return this.version;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String packaging() {
        return this.packaging;
    }

    private static final class ModelReader
    implements XMLReader {
        private static final int STOP = 511;
        private final LinkedList<String> stack = new LinkedList();
        private boolean hasParent;
        private String parentGroupId;
        private String parentArtifactId;
        private String parentVersion;
        private String groupId;
        private String artifactId;
        private String version;
        private String name;
        private String description;
        private String packaging;
        private int mask = 0;

        private ModelReader() {
        }

        public boolean keepParsing() {
            return this.mask != 511;
        }

        public void startElement(String qName, Map<String, String> attributes) {
            String parentQName = this.stack.peek();
            if (parentQName == null && !"project".equals(qName)) {
                throw new IllegalStateException("Invalid root element '" + qName + "'");
            }
            this.stack.push(qName);
        }

        public void endElement(String name) {
            this.stack.pop();
            if (this.stack.isEmpty()) {
                this.mask = 511;
            } else if ("parent".equals(name)) {
                this.mask |= 7;
            }
        }

        public void elementText(String data) {
            if (this.stack.size() >= 2) {
                String qName = this.stack.get(0);
                String parentQName = this.stack.get(1);
                if ("project".equals(parentQName)) {
                    switch (qName) {
                        case "groupId": {
                            this.groupId = data;
                            this.mask |= 8;
                            break;
                        }
                        case "artifactId": {
                            this.artifactId = data;
                            this.mask |= 0x10;
                            break;
                        }
                        case "version": {
                            this.version = data;
                            this.mask |= 0x20;
                            break;
                        }
                        case "name": {
                            this.name = data;
                            this.mask |= 0x40;
                            break;
                        }
                        case "description": {
                            this.description = data;
                            this.mask |= 0x80;
                            break;
                        }
                        case "packaging": {
                            this.packaging = data;
                            this.mask |= 0x100;
                            break;
                        }
                    }
                } else if ("parent".equals(parentQName)) {
                    switch (qName) {
                        case "groupId": {
                            this.hasParent = true;
                            this.parentGroupId = data;
                            this.mask |= 2;
                            break;
                        }
                        case "artifactId": {
                            this.hasParent = true;
                            this.parentArtifactId = data;
                            this.mask |= 4;
                            break;
                        }
                        case "version": {
                            this.hasParent = true;
                            this.parentVersion = data;
                            this.mask |= 8;
                            break;
                        }
                    }
                }
            }
        }
    }

    public static class Parent {
        private final String groupId;
        private final String artifactId;
        private final String version;

        private Parent(String groupId, String artifactId, String version) {
            this.groupId = Strings.requireValid((String)groupId, (String)"parent groupId is not valid");
            this.artifactId = Strings.requireValid((String)artifactId, (String)"parent artifactId is not valid");
            this.version = Strings.requireValid((String)version, (String)"parent version is not valid");
        }

        public String groupId() {
            return this.groupId;
        }

        public String artifactId() {
            return this.artifactId;
        }

        public String version() {
            return this.version;
        }
    }
}

