/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.maven;

import io.helidon.build.common.maven.MavenVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;

public class VersionRange {
    private static final Map<String, VersionRange> CACHE_SPEC = Collections.synchronizedMap(new WeakHashMap());
    private final MavenVersion recommendedVersion;
    private final List<Restriction> restrictions;

    private VersionRange(MavenVersion recommendedVersion, List<Restriction> restrictions) {
        this.recommendedVersion = recommendedVersion;
        this.restrictions = restrictions;
    }

    public static VersionRange createFromVersionSpec(String spec) {
        if (spec == null) {
            return null;
        }
        VersionRange cached = CACHE_SPEC.get(spec);
        if (cached != null) {
            return cached;
        }
        ArrayList<Restriction> restrictions = new ArrayList<Restriction>();
        String process = spec;
        MavenVersion version = null;
        MavenVersion upperBound = null;
        MavenVersion lowerBound = null;
        while (process.startsWith("[") || process.startsWith("(")) {
            int index2;
            int index1 = process.indexOf(41);
            int index = index2 = process.indexOf(93);
            if ((index2 < 0 || index1 < index2) && index1 >= 0) {
                index = index1;
            }
            if (index < 0) {
                throw new IllegalArgumentException("Unbounded range: " + spec);
            }
            Restriction restriction = VersionRange.parseRestriction(process.substring(0, index + 1));
            if (lowerBound == null) {
                lowerBound = restriction.getLowerBound();
            }
            if (upperBound != null && (restriction.getLowerBound() == null || restriction.getLowerBound().compareTo(upperBound) < 0)) {
                throw new IllegalArgumentException("Ranges overlap: " + spec);
            }
            restrictions.add(restriction);
            upperBound = restriction.getUpperBound();
            if (!(process = process.substring(index + 1).trim()).startsWith(",")) continue;
            process = process.substring(1).trim();
        }
        if (process.length() > 0) {
            if (restrictions.size() > 0) {
                throw new IllegalArgumentException("Only fully-qualified sets allowed in multiple set scenario: " + spec);
            }
            version = MavenVersion.toMavenVersion(process);
            restrictions.add(Restriction.EVERYTHING);
        }
        cached = new VersionRange(version, restrictions);
        CACHE_SPEC.put(spec, cached);
        return cached;
    }

    public static VersionRange higherOrEqual(String version) {
        return VersionRange.createFromVersionSpec("[" + version + ",)");
    }

    public static VersionRange wildcard(String version) {
        if (version.endsWith("-latest") || version.endsWith("-LATEST")) {
            return VersionRange.createFromVersionSpec("[" + version.substring(0, version.length() - 7) + ",)");
        }
        return VersionRange.createFromVersionSpec("[" + version + "]");
    }

    public MavenVersion resolveLatest(List<MavenVersion> versions) {
        MavenVersion version = this.matchVersion(versions);
        return version != null ? version : versions.get(versions.size() - 1);
    }

    public MavenVersion matchVersion(List<MavenVersion> versions) {
        return versions.stream().filter(this::containsVersion).max(Comparator.naturalOrder()).orElse(null);
    }

    public boolean containsVersion(MavenVersion version) {
        for (Restriction restriction : this.restrictions) {
            if (!restriction.containsVersion(version)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VersionRange)) {
            return false;
        }
        VersionRange other = (VersionRange)obj;
        return Objects.equals(this.recommendedVersion, other.recommendedVersion) && Objects.equals(this.restrictions, other.restrictions);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.recommendedVersion == null ? 0 : this.recommendedVersion.hashCode());
        hash = 31 * hash + (this.restrictions == null ? 0 : this.restrictions.hashCode());
        return hash;
    }

    public String toString() {
        if (this.recommendedVersion != null) {
            return this.recommendedVersion.toString();
        }
        StringBuilder buf = new StringBuilder();
        for (Restriction r : this.restrictions) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(r.toString());
        }
        return buf.toString();
    }

    private static Restriction parseRestriction(String spec) {
        Restriction restriction;
        boolean lowerBoundInclusive = spec.startsWith("[");
        boolean upperBoundInclusive = spec.endsWith("]");
        String process = spec.substring(1, spec.length() - 1).trim();
        int index = process.indexOf(44);
        if (index < 0) {
            if (!lowerBoundInclusive || !upperBoundInclusive) {
                throw new IllegalArgumentException("Single version must be surrounded by []: " + spec);
            }
            MavenVersion version = MavenVersion.toMavenVersion(process);
            restriction = new Restriction(version, lowerBoundInclusive, version, upperBoundInclusive);
        } else {
            String upperBound;
            String lowerBound = process.substring(0, index).trim();
            if (lowerBound.equals(upperBound = process.substring(index + 1).trim())) {
                throw new IllegalArgumentException("Range cannot have identical boundaries: " + spec);
            }
            MavenVersion lowerVersion = null;
            if (lowerBound.length() > 0) {
                lowerVersion = MavenVersion.toMavenVersion(lowerBound);
            }
            MavenVersion upperVersion = null;
            if (upperBound.length() > 0) {
                upperVersion = MavenVersion.toMavenVersion(upperBound);
            }
            if (upperVersion != null && lowerVersion != null && upperVersion.compareTo(lowerVersion) < 0) {
                throw new IllegalArgumentException("Range defies version ordering: " + spec);
            }
            restriction = new Restriction(lowerVersion, lowerBoundInclusive, upperVersion, upperBoundInclusive);
        }
        return restriction;
    }

    private static class Restriction {
        private final MavenVersion lowerBound;
        private final boolean lowerBoundInclusive;
        private final MavenVersion upperBound;
        private final boolean upperBoundInclusive;
        public static final Restriction EVERYTHING = new Restriction(null, false, null, false);

        Restriction(MavenVersion lowerBound, boolean lowerBoundInclusive, MavenVersion upperBound, boolean upperBoundInclusive) {
            this.lowerBound = lowerBound;
            this.lowerBoundInclusive = lowerBoundInclusive;
            this.upperBound = upperBound;
            this.upperBoundInclusive = upperBoundInclusive;
        }

        MavenVersion getLowerBound() {
            return this.lowerBound;
        }

        boolean isLowerBoundInclusive() {
            return this.lowerBoundInclusive;
        }

        MavenVersion getUpperBound() {
            return this.upperBound;
        }

        boolean isUpperBoundInclusive() {
            return this.upperBoundInclusive;
        }

        boolean containsVersion(MavenVersion version) {
            int comparison;
            if (this.lowerBound != null) {
                comparison = this.lowerBound.compareTo(version);
                if (comparison == 0 && !this.lowerBoundInclusive) {
                    return false;
                }
                if (comparison > 0) {
                    return false;
                }
            }
            if (this.upperBound != null) {
                comparison = this.upperBound.compareTo(version);
                if (comparison == 0 && !this.upperBoundInclusive) {
                    return false;
                }
                return comparison >= 0;
            }
            return true;
        }

        public int hashCode() {
            int result = 13;
            result = this.lowerBound == null ? ++result : (result += this.lowerBound.hashCode());
            result *= this.lowerBoundInclusive ? 1 : 2;
            result = this.upperBound == null ? (result -= 3) : (result -= this.upperBound.hashCode());
            return result *= this.upperBoundInclusive ? 2 : 3;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Restriction)) {
                return false;
            }
            Restriction restriction = (Restriction)other;
            if (this.lowerBound != null ? !this.lowerBound.equals(restriction.lowerBound) : restriction.lowerBound != null) {
                return false;
            }
            if (this.lowerBoundInclusive != restriction.lowerBoundInclusive) {
                return false;
            }
            if (this.upperBound != null ? !this.upperBound.equals(restriction.upperBound) : restriction.upperBound != null) {
                return false;
            }
            return this.upperBoundInclusive == restriction.upperBoundInclusive;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.isLowerBoundInclusive() ? (char)'[' : '(');
            if (this.getLowerBound() != null) {
                buf.append(this.getLowerBound());
            }
            buf.append(',');
            if (this.getUpperBound() != null) {
                buf.append(this.getUpperBound());
            }
            buf.append(this.isUpperBoundInclusive() ? (char)']' : ')');
            return buf.toString();
        }
    }
}

