/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.xml;

import io.helidon.build.common.xml.XMLException;
import io.helidon.build.common.xml.XMLParser;
import io.helidon.build.common.xml.XMLReader;
import io.helidon.build.common.xml.XMLWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface XMLElement {
    public String name();

    public XMLElement parent();

    public List<XMLElement> children();

    public List<XMLElement> children(String var1);

    default public List<XMLElement> childrenAt(String ... path) {
        if (path.length == 0) {
            return List.of();
        }
        Stream<XMLElement> stream = Stream.of(this);
        for (String p : path) {
            stream = stream.flatMap(e -> e.children(p).stream());
        }
        return stream.collect(Collectors.toList());
    }

    public Optional<XMLElement> child(String var1);

    public Map<String, String> attributes();

    default public String attribute(String key) {
        String value = this.attributes().get(key);
        if (value == null) {
            throw new XMLException(String.format("Missing required attribute '%s', element: '%s'", key, this.name()));
        }
        return value;
    }

    default public String attribute(String key, String defaultValue) {
        return this.attributes().getOrDefault(key, defaultValue);
    }

    default public <T> T attribute(String key, Function<String, T> mapper, T defaultValue) {
        String value = this.attributes().get(key);
        if (value != null) {
            return mapper.apply(value);
        }
        return defaultValue;
    }

    default public List<String> attributeList(String key, String separator) {
        String value = this.attribute(key, null);
        return value == null ? List.of() : Arrays.asList(value.split(separator));
    }

    default public boolean attributeBoolean(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.attribute(key, defaultValue ? "true" : "false"));
    }

    public String value();

    public void value(String var1);

    public void visit(Visitor var1);

    public XMLElement detach();

    public static XMLElement parse(InputStream is) throws IOException {
        ReaderImpl reader = new ReaderImpl();
        new XMLParser(is, reader).parse();
        if (!reader.stack.isEmpty()) {
            return reader.stack.pop().build();
        }
        throw new XMLException("document is empty");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class ReaderImpl
    implements XMLReader {
        private final Deque<Builder> stack = new ArrayDeque<Builder>();

        @Override
        public void startElement(String name, Map<String, String> attributes) {
            Builder ctx = new Builder();
            ctx.parent = this.stack.peek();
            ctx.name = name;
            ctx.attributes = attributes;
            this.stack.push(ctx);
        }

        @Override
        public void endElement(String name) {
            Builder ctx = this.peek();
            if (ctx.parent != null) {
                ctx.parent.childBuilders.add(ctx);
            }
            if (this.stack.size() > 1) {
                this.stack.pop();
            }
        }

        @Override
        public void elementText(String data) {
            Builder ctx = this.peek();
            ctx.value = data;
        }

        private Builder peek() {
            Builder ctx = this.stack.peek();
            if (ctx == null) {
                throw new IllegalStateException("context is null");
            }
            return ctx;
        }
    }

    public static final class Builder {
        private Builder parent;
        private String name;
        private final List<Builder> childBuilders = new ArrayList<Builder>();
        private Map<String, String> attributes = Map.of();
        private String value = "";
        private boolean modifiable;
        private XMLElement elt;
        private List<XMLElement> childElements = List.of();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder attributes(Map<String, String> attributes) {
            this.attributes = new HashMap<String, String>(attributes);
            return this;
        }

        public Builder value(String value) {
            if (value != null) {
                this.value = value;
            }
            return this;
        }

        public Builder child(Builder child) {
            this.childBuilders.add(child);
            child.parent = this;
            return this;
        }

        public Builder child(Consumer<Builder> consumer) {
            Builder child = new Builder().modifiable(this.modifiable);
            consumer.accept(child);
            return this.child(child);
        }

        public Builder modifiable(boolean modifiable) {
            this.modifiable = modifiable;
            return this;
        }

        public XMLElement build() {
            ArrayDeque<Builder> builders = new ArrayDeque<Builder>(this.childBuilders);
            this.elt = this.build0();
            while (!builders.isEmpty()) {
                Builder builder = (Builder)builders.pop();
                builder.elt = builder.build0();
                builder.parent.childElements.add(builder.elt);
                for (int i = builder.childBuilders.size() - 1; i >= 0; --i) {
                    builders.push(builder.childBuilders.get(i));
                }
            }
            return this.elt;
        }

        private XMLElement build0() {
            XMLElement parentElt;
            this.childElements = new ArrayList<XMLElement>();
            XMLElement xMLElement = parentElt = this.parent != null ? this.parent.elt : null;
            if (this.modifiable) {
                return new XMLElementImpl(parentElt, this.childElements, this);
            }
            return new UnmodifiableXMLElement(parentElt, this.childElements, this);
        }
    }

    public static class XMLElementImpl
    implements XMLElement {
        private final XMLElement parent;
        private final List<XMLElement> children;
        private final Map<String, String> attributes;
        private final String name;
        private String value;

        private XMLElementImpl(XMLElement parent, List<XMLElement> children, Map<String, String> attributes, String name, String value) {
            this.parent = parent;
            this.children = children;
            this.attributes = attributes;
            this.name = Objects.requireNonNull(name, "name is null!");
            this.value = value;
        }

        private XMLElementImpl(XMLElement parent, List<XMLElement> children, Builder builder) {
            this(parent, children, builder.attributes, builder.name, builder.value);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public XMLElement parent() {
            return this.parent;
        }

        @Override
        public List<XMLElement> children() {
            return this.children;
        }

        @Override
        public List<XMLElement> children(String name) {
            return this.children.stream().filter(e -> e.name().equals(name)).collect(Collectors.toList());
        }

        @Override
        public Optional<XMLElement> child(String name) {
            return this.children(name).stream().findFirst();
        }

        @Override
        public Map<String, String> attributes() {
            return this.attributes;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public void value(String value) {
            this.value = value;
        }

        @Override
        public void visit(Visitor visitor) {
            ArrayDeque<XMLElement> stack = new ArrayDeque<XMLElement>();
            stack.push(this);
            XMLElement parent = this.parent;
            while (!stack.isEmpty()) {
                XMLElement elt = (XMLElement)stack.peek();
                if (elt == parent) {
                    visitor.postVisitElement(elt);
                    parent = elt.parent();
                    stack.pop();
                    continue;
                }
                visitor.visitElement(elt);
                parent = elt;
                List<XMLElement> children = elt.children();
                for (int i = children.size() - 1; i >= 0; --i) {
                    stack.push(children.get(i));
                }
            }
        }

        @Override
        public XMLElement detach() {
            final ArrayDeque stack = new ArrayDeque();
            this.visit(new Visitor(){

                @Override
                public void visitElement(XMLElement elt) {
                    Builder builder = XMLElement.builder().modifiable(!(elt instanceof UnmodifiableXMLElement)).name(elt.name()).attributes(elt.attributes()).value(elt.value());
                    if (!stack.isEmpty()) {
                        ((Builder)stack.peek()).child(builder);
                    }
                    stack.push(builder);
                }

                @Override
                public void postVisitElement(XMLElement elt) {
                    if (stack.size() > 1) {
                        stack.pop();
                    }
                }
            });
            return ((Builder)stack.pop()).build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            XMLElementImpl that = (XMLElementImpl)o;
            return Objects.equals(this.children, that.children) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.children, this.attributes, this.name, this.value);
        }

        public String toString() {
            StringWriter buf = new StringWriter();
            XMLWriter writer = new XMLWriter(buf);
            writer.append(this);
            writer.close();
            return buf.toString();
        }
    }

    public static final class UnmodifiableXMLElement
    extends XMLElementImpl {
        private final Map<String, List<XMLElement>> names = new HashMap<String, List<XMLElement>>();

        private UnmodifiableXMLElement(XMLElement parent, List<XMLElement> children, Builder builder) {
            super(parent, Collections.unmodifiableList(children), Collections.unmodifiableMap(builder.attributes), builder.name, builder.value);
        }

        @Override
        public void value(String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<XMLElement> children(String name) {
            return this.names.computeIfAbsent(name, x$0 -> super.children((String)x$0));
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static interface Visitor {
        default public void visitElement(XMLElement elt) {
        }

        default public void postVisitElement(XMLElement elt) {
        }
    }
}

