/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.xml;

import io.helidon.build.common.xml.XMLElement;
import io.helidon.build.common.xml.XMLException;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;

public class XMLWriter
implements Closeable {
    private static final int ATTRIBUTE_MASK = 2;
    private static final int VALUE_MASK = 4;
    private static final int ELEMENT_MASK = 8;
    private final Writer writer;
    private final Deque<String> names = new ArrayDeque<String>();
    private String token;
    private int depth;
    private int state;

    public XMLWriter(Writer writer) {
        this.writer = writer;
    }

    public void append(XMLElement elt) {
        elt.visit(new XMLElement.Visitor(){

            @Override
            public void visitElement(XMLElement elt) {
                XMLWriter.this.startElement(elt.name());
                elt.attributes().forEach(XMLWriter.this::attribute);
            }

            @Override
            public void postVisitElement(XMLElement elt) {
                XMLWriter.this.value(elt.value());
                XMLWriter.this.endElement();
            }
        });
    }

    public XMLWriter prolog() {
        if ((this.state & 8) == 8) {
            throw new XMLException("Cannot write prolog");
        }
        this.state |= 8;
        return this.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    }

    public XMLWriter startElement(String name) {
        if ((this.state & 2) == 2) {
            this.append(">");
        }
        if ((this.state & 4) == 0) {
            this.indent();
        }
        this.append("<").append(name);
        this.state = 10;
        this.depth = this.names.size();
        this.names.push(name);
        return this;
    }

    public XMLWriter endElement() {
        if (this.names.isEmpty()) {
            throw new XMLException("No element opened");
        }
        String name = this.names.pop();
        if (this.depth == this.names.size()) {
            if ((this.state & 2) == 2) {
                this.state = 8;
                return this.append("/>");
            }
        } else if ((this.state & 4) == 0) {
            this.indent();
        }
        this.state = 8;
        this.append("</").append(name).append(">");
        return this;
    }

    public XMLWriter attribute(String name, Object value) {
        return this.attribute(name, value.toString());
    }

    public XMLWriter attribute(String name, String value) {
        return this.append(" ").append(XMLWriter.encode(name)).append("=\"").append(XMLWriter.encode(value)).append("\"");
    }

    public XMLWriter value(String value) {
        if (value == null || value.isEmpty()) {
            return this;
        }
        if ((this.state & 4) == 4) {
            throw new XMLException("value already set");
        }
        this.state |= 4;
        if ((this.state & 2) == 2) {
            this.append(">");
            this.state ^= 2;
        }
        return this.append(XMLWriter.encode(value));
    }

    @Override
    public void close() {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private XMLWriter append(String str) {
        try {
            this.writer.append(str);
            this.token = str;
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void indent() {
        if (this.token != null && !this.token.endsWith("\n")) {
            this.append("\n");
        }
        if (!this.names.isEmpty()) {
            for (int i = 0; i < this.names.size(); ++i) {
                this.append("    ");
            }
        }
    }

    private static String encode(String str) {
        return str.replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }
}

