/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import io.helidon.build.common.Strings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class ConfigProperties {
    private static final String DELIMITER = ",";
    private final Path file;
    private final Properties properties;

    public ConfigProperties(Path file) {
        this.file = file;
        this.properties = new Properties();
        this.load();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigProperties)) {
            return false;
        }
        ConfigProperties that = (ConfigProperties)o;
        return Objects.equals(this.file, that.file) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.properties);
    }

    public Path file() {
        return this.file;
    }

    public boolean exists() {
        return Files.exists(this.file, new LinkOption[0]) && Files.isRegularFile(this.file, new LinkOption[0]);
    }

    public String property(String key) {
        return this.properties.getProperty(key);
    }

    public void property(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public List<String> propertyAsList(String key) {
        String value = this.properties.getProperty(key);
        if (Strings.isNotValid(value)) {
            return Collections.emptyList();
        }
        return Arrays.stream(value.split(DELIMITER)).filter(v -> !v.isEmpty()).collect(Collectors.toList());
    }

    public void property(String key, Collection<String> values) {
        this.properties.setProperty(key, String.join((CharSequence)DELIMITER, values));
    }

    public boolean contains(String key) {
        return this.properties.containsKey(key);
    }

    public boolean remove(String key) {
        return this.properties.remove(key) != null;
    }

    public Set<String> keySet() {
        return this.properties.keySet();
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.properties.entrySet();
    }

    public void load() {
        if (this.exists()) {
            try (BufferedReader reader = Files.newBufferedReader(this.file);){
                this.properties.load(reader);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public void store() {
        this.store(null);
    }

    public void store(String comments) {
        try (BufferedWriter writer = Files.newBufferedWriter(this.file, new OpenOption[0]);){
            this.properties.store(writer, comments);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

