/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import io.helidon.build.common.logging.Log;
import io.helidon.build.common.logging.LogLevel;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Objects;

public class NetworkConnection {
    public static final Connector DEFAULT_CONNECTOR = (url, connectTimeout, readTimeout) -> {
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(connectTimeout);
        connection.setReadTimeout(readTimeout);
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).setInstanceFollowRedirects(true);
        }
        return connection.getInputStream();
    };
    public static final int DEFAULT_MAXIMUM_RETRIES = 5;
    public static final int DEFAULT_CONNECT_TIMEOUT = 500;
    public static final int DEFAULT_READ_TIMEOUT = 500;
    public static final RetryDelay DEFAULT_RETRY_DELAY = new LinearRetryDelay(500L, 500L);

    public static Builder builder() {
        return new Builder();
    }

    private NetworkConnection() {
    }

    public static class Builder {
        private URL url;
        private int maxRetries = 5;
        private int connectTimeout = 500;
        private int readTimeout = 500;
        private Connector connector = DEFAULT_CONNECTOR;
        private RetryDelay delay = DEFAULT_RETRY_DELAY;

        private Builder() {
        }

        public Builder url(String url) {
            try {
                return this.url(new URL(Objects.requireNonNull(url)));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        public Builder url(URL url) {
            this.url = Objects.requireNonNull(url);
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            if (maxRetries <= 0) {
                throw new IllegalArgumentException("maxRetries must be > 0");
            }
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            if (connectTimeout <= 0) {
                throw new IllegalArgumentException("connect timeout must be > 0");
            }
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            if (readTimeout <= 0) {
                throw new IllegalArgumentException("read timeout must be > 0");
            }
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder connector(Connector connector) {
            this.connector = Objects.requireNonNull(connector);
            return this;
        }

        public Builder retryDelay(RetryDelay retryDelay) {
            this.delay = Objects.requireNonNull(retryDelay);
            return this;
        }

        public InputStream open() throws IOException {
            if (this.url == null) {
                throw new IllegalStateException("url is required");
            }
            Log.debug("attempting to open %s", this.url);
            IOException lastCaught = null;
            for (int attempt = 1; attempt <= this.maxRetries; ++attempt) {
                try {
                    InputStream result = this.connector.connect(this.url, this.connectTimeout, this.readTimeout);
                    Log.debug("opened %s", this.url);
                    return result;
                }
                catch (SocketException | SocketTimeoutException | UnknownHostException e) {
                    lastCaught = e;
                    this.delay.execute(attempt, this.maxRetries);
                    continue;
                }
            }
            throw (IOException)Objects.requireNonNull(lastCaught);
        }
    }

    public static interface Connector {
        public InputStream connect(URL var1, int var2, int var3) throws IOException;
    }

    public static final class LinearRetryDelay
    implements RetryDelay {
        private final long initialDelay;
        private final long increment;

        public LinearRetryDelay(long initialDelay, long increment) {
            this.initialDelay = initialDelay;
            this.increment = increment;
        }

        @Override
        public void execute(int attempt, int maxAttempts) {
            try {
                long delay = this.initialDelay + (long)attempt * this.increment;
                if (LogLevel.isVerbose()) {
                    float seconds = (float)delay / 1000.0f;
                    Log.info("  $(italic retry %d of %d, sleeping for %.1f seconds)", attempt, maxAttempts, Float.valueOf(seconds));
                } else {
                    Log.info("  $(italic retry %d of %d)", attempt, maxAttempts);
                }
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface RetryDelay {
        public void execute(int var1, int var2);
    }
}

