/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import java.util.Locale;

public enum OSType {
    MacOS("java", true, null, "-f %m", "mvn", "\\\""),
    Windows("java.exe", false, "powershell.exe", "%s", "mvn.cmd", "`\""){

        @Override
        public String withScriptExtension(String scriptName) {
            return scriptName + ".ps1";
        }
    }
    ,
    Linux("java", true, null, "-c %Y", "mvn", "\\\""),
    Unknown("java", true, null, null, "mvn", "\\\"");

    private final String javaExecutable;
    private final boolean posix;
    private final String scriptExecutor;
    private final String statFormat;
    private final String mavenExec;
    private final String escapedQuote;

    private OSType(String javaExecutable, boolean posix, String scriptExecutor, String statFormat, String mavenExec, String escapedQuote) {
        this.javaExecutable = javaExecutable;
        this.posix = posix;
        this.scriptExecutor = scriptExecutor;
        this.statFormat = statFormat;
        this.mavenExec = mavenExec;
        this.escapedQuote = escapedQuote;
    }

    public static OSType currentOS() {
        String name = System.getProperty("os.name", "unknown").toLowerCase(Locale.ENGLISH);
        if (name.contains("win")) {
            return Windows;
        }
        if (name.contains("mac") || name.contains("darwin")) {
            return MacOS;
        }
        if (name.contains("linux") || name.contains("unix") || name.contains("solaris") || name.contains("aix") || name.contains("freebsd") || name.contains("sunos")) {
            return Linux;
        }
        return Unknown;
    }

    public String javaExecutable() {
        return this.javaExecutable;
    }

    public String withScriptExtension(String scriptName) {
        return scriptName;
    }

    public boolean isPosix() {
        return this.posix;
    }

    public String scriptExecutor() {
        return this.scriptExecutor;
    }

    public String statFormat() {
        return this.statFormat;
    }

    public String mavenExec() {
        return this.mavenExec;
    }

    public String escapedQuote() {
        return this.escapedQuote;
    }
}

