/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import io.helidon.build.common.RichText;
import io.helidon.build.common.RichTextProvider;
import io.helidon.build.common.RichTextStyle;

public class RichTextRenderer {
    private static final String START_TOKEN = "$(";
    private static final int START_TOKEN_LEN = "$(".length();
    private static final char ESCAPE_CHAR = '\\';
    private static final char STYLES_SEP_CHAR = ' ';
    private static final String STYLE_SEP = ",";
    private static final char END_TOKEN_CHAR = ')';
    private static final String ESCAPED_END_TOKEN = "\\)";
    private static final String END_TOKEN = ")";
    private final String text;
    private final int textLength;
    private final RichText richText;
    private int textStart;
    private int tokenStart;
    private int tokenEnd;
    private RichTextStyle nestedStyle;

    private RichTextRenderer(String text, int tokenStart) {
        this.text = text;
        this.richText = RichTextProvider.Holder.INSTANCE.richText();
        this.textLength = text.length();
        this.tokenStart = tokenStart;
        this.nestedStyle = RichTextStyle.NONE;
    }

    public static String render(String text) {
        int tokenStart = text.indexOf(START_TOKEN);
        if (tokenStart >= 0) {
            return new RichTextRenderer(text, tokenStart).render();
        }
        return text;
    }

    public static String render(String format, Object ... args) {
        return RichTextRenderer.render(String.format(format, args));
    }

    private String render() {
        while (this.tokenStart >= 0) {
            if (this.textStart < this.tokenStart) {
                this.richText.append(this.text, this.textStart, this.tokenStart);
            }
            if (this.replaceNext(this.tokenStart)) continue;
        }
        if (this.textStart < this.textLength) {
            this.richText.append(this.text.substring(this.textStart));
        }
        return this.richText.text();
    }

    private boolean replaceNext(int tokenStart) {
        int stylesStart = tokenStart + START_TOKEN_LEN;
        int stylesEnd = this.text.indexOf(32, stylesStart);
        if (stylesEnd < 0) {
            return false;
        }
        this.tokenEnd = this.tokenEnd(stylesEnd);
        if (this.tokenEnd < 0) {
            return false;
        }
        return this.replaceNext(stylesStart, stylesEnd);
    }

    private boolean replaceNext(int stylesStart, int stylesEnd) {
        int nextTokenStart = this.tokenStart(stylesEnd);
        boolean nested = nextTokenStart >= 0 && nextTokenStart < this.tokenEnd;
        int styledTextStart = stylesEnd + 1;
        int styledTextEnd = nested ? nextTokenStart : this.tokenEnd;
        String styleNames = this.text.substring(stylesStart, stylesEnd);
        String styledText = this.text.substring(styledTextStart, styledTextEnd);
        String unescapedText = styledText.replace(ESCAPED_END_TOKEN, END_TOKEN);
        RichTextStyle style = RichTextProvider.Holder.INSTANCE.styleOf(styleNames.split(STYLE_SEP));
        style.apply(this.richText).append(unescapedText);
        if (nested) {
            this.push(style);
            if (this.replaceNext(nextTokenStart)) {
                this.pop();
                this.tokenEnd = this.tokenEnd(this.textStart);
                if (this.tokenEnd < 0) {
                    style.reset(this.richText);
                    return false;
                }
                this.richText.append(this.text, this.textStart, this.tokenEnd);
                nextTokenStart = this.tokenStart(this.tokenEnd);
            } else {
                return false;
            }
        }
        this.tokenStart = nextTokenStart;
        this.textStart = this.tokenEnd + 1;
        style.reset(this.richText);
        return true;
    }

    private void push(RichTextStyle style) {
        if (this.nestedStyle == RichTextStyle.NONE) {
            this.nestedStyle = style;
        } else if (!(this.nestedStyle instanceof RichTextStyle.StyleList)) {
            this.nestedStyle = new RichTextStyle.StyleList(this.nestedStyle).add(style);
        } else {
            ((RichTextStyle.StyleList)this.nestedStyle).add(style);
        }
    }

    private void pop() {
        this.nestedStyle.apply(this.richText);
        if (this.nestedStyle instanceof RichTextStyle.StyleList) {
            ((RichTextStyle.StyleList)this.nestedStyle).pop();
        }
    }

    private int tokenStart(int stylesEnd) {
        return this.text.indexOf(START_TOKEN, stylesEnd + 1);
    }

    private int tokenEnd(int stylesEnd) {
        int tokenEnd;
        while (stylesEnd < this.textLength && (tokenEnd = this.text.indexOf(41, stylesEnd)) >= 0) {
            if (this.text.charAt(tokenEnd - 1) != '\\') {
                return tokenEnd;
            }
            stylesEnd = tokenEnd + 1;
        }
        return -1;
    }
}

