/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import io.helidon.build.common.FileUtils;
import io.helidon.build.common.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.ProviderMismatchException;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class VirtualFileSystem
extends FileSystem {
    private static final ProviderImpl PROVIDER = new ProviderImpl();
    private final Path internal;
    private final VPath root;
    private volatile boolean isOpen;

    public static FileSystem create(Path path) {
        return new VirtualFileSystem(path);
    }

    public static FileSystem create() {
        return new VirtualFileSystem(null);
    }

    public static Path unwrap(Path path) {
        if (path instanceof VPath) {
            return ((VPath)path).internal;
        }
        return path;
    }

    private VirtualFileSystem(Path internal) {
        if (internal == null) {
            internal = FileUtils.randomPath(null, null);
        }
        this.internal = internal.normalize().toAbsolutePath();
        this.root = new VPath(this, "/");
        this.isOpen = true;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() {
        this.cleanup();
    }

    protected void finalize() {
        this.cleanup();
    }

    @Override
    public FileSystemProvider provider() {
        return PROVIDER;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singleton(this.root);
    }

    @Override
    public Path getPath(String first, String ... more) {
        if (more.length == 0) {
            return new VPath(this, first);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(first);
        for (String s : more) {
            if (s.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append(s);
        }
        return new VPath(this, sb.toString());
    }

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    @Override
    public final UserPrincipalLookupService getUserPrincipalLookupService() {
        return this.internal.getFileSystem().getUserPrincipalLookupService();
    }

    @Override
    public final WatchService newWatchService() throws IOException {
        return this.internal.getFileSystem().newWatchService();
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndInput) {
        return this.internal.getFileSystem().getPathMatcher(syntaxAndInput);
    }

    @Override
    public final Iterable<FileStore> getFileStores() {
        return this.internal.getFileSystem().getFileStores();
    }

    @Override
    public final Set<String> supportedFileAttributeViews() {
        return this.internal.getFileSystem().supportedFileAttributeViews();
    }

    public final String toString() {
        return "virtual:" + this.internal.toUri();
    }

    @Override
    public final String getSeparator() {
        return "/";
    }

    private boolean isNotWithinBounds(Path path) {
        return !path.normalize().toAbsolutePath().startsWith(this.internal);
    }

    private synchronized void cleanup() {
        if (this.isOpen) {
            this.isOpen = false;
        }
    }

    private static VPath unwrap0(Path path) {
        Objects.requireNonNull(path, "path");
        if (!(path instanceof VPath)) {
            throw new ProviderMismatchException();
        }
        return (VPath)path;
    }

    private static final class VPath
    implements Path {
        private final VirtualFileSystem fs;
        private final Path internal;

        VPath(VirtualFileSystem fs, Path path) {
            if (path.isAbsolute() && fs.isNotWithinBounds(path)) {
                throw new InvalidVirtualPathException(fs, path.toString());
            }
            this.internal = path;
            this.fs = fs;
        }

        VPath(VirtualFileSystem fs, String path) {
            if ("/".equals(path)) {
                this.internal = fs.internal;
            } else {
                String normalized = Strings.stripLeading(path, '/');
                Path internal = fs.internal.getFileSystem().getPath(normalized, new String[0]);
                if (internal.isAbsolute() && fs.isNotWithinBounds(internal)) {
                    throw new InvalidVirtualPathException(fs, path);
                }
                this.internal = internal;
            }
            this.fs = fs;
        }

        @Override
        public VPath getRoot() {
            return this.internal.isAbsolute() ? this.fs.root : null;
        }

        Path internalAbsolute() {
            Path path;
            Path path2 = path = this.internal.isAbsolute() ? this.internal : this.fs.internal.resolve(this.internal).toAbsolutePath();
            if (this.fs.isNotWithinBounds(path)) {
                throw new InvalidVirtualPathException(this.fs, path.toString());
            }
            return path;
        }

        FileSystemProvider internalProvider() {
            return this.internal.getFileSystem().provider();
        }

        @Override
        public VPath getFileName() {
            return new VPath(this.fs, this.internal.getFileName());
        }

        @Override
        public VPath getParent() {
            Path parent = this.internal.getParent();
            return parent != null ? new VPath(this.fs, parent) : null;
        }

        @Override
        public int getNameCount() {
            int count = this.internal.getNameCount();
            return this.internal.isAbsolute() ? count - this.fs.internal.getNameCount() : count;
        }

        @Override
        public VPath getName(int index) {
            Path name = this.internal.startsWith(this.fs.internal) ? this.internal.getName(this.fs.internal.getNameCount() + index) : this.internal.getName(index);
            return new VPath(this.fs, name);
        }

        @Override
        public VPath subpath(int beginIndex, int endIndex) {
            if (this.internal.startsWith(this.fs.internal)) {
                int count = this.fs.internal.getNameCount();
                beginIndex += count;
                endIndex += count;
            }
            return new VPath(this.fs, this.internal.subpath(beginIndex, endIndex));
        }

        @Override
        public VPath toRealPath(LinkOption ... options) throws IOException {
            return new VPath(this.fs, this.internalAbsolute().toRealPath(options));
        }

        @Override
        public VPath toAbsolutePath() {
            if (this.internal.isAbsolute()) {
                return this;
            }
            return new VPath(this.fs, this.internalAbsolute());
        }

        @Override
        public URI toUri() {
            try {
                return new URI("virtual", String.format("%s!%s", this.fs.internal.toUri(), this.fs.internal.relativize(this.internalAbsolute().normalize())), null);
            }
            catch (URISyntaxException ex) {
                throw new AssertionError((Object)ex);
            }
        }

        @Override
        public VPath relativize(Path other) {
            VPath o = VirtualFileSystem.unwrap0(other);
            if (this.fs != o.fs || this.isAbsolute() != o.isAbsolute()) {
                throw new IllegalArgumentException("Incorrect filesystem or path: " + other);
            }
            return new VPath(this.fs, this.internal.relativize(o.internal));
        }

        @Override
        public VirtualFileSystem getFileSystem() {
            return this.fs;
        }

        @Override
        public boolean isAbsolute() {
            return this.internal.isAbsolute();
        }

        @Override
        public VPath resolve(Path other) {
            VPath o = VirtualFileSystem.unwrap0(other);
            if (o.internal.isAbsolute()) {
                return o;
            }
            Path path = o.internal;
            String pathStr = path.toString();
            if (pathStr.startsWith("/") || pathStr.startsWith("\\")) {
                return new VPath(this.fs, this.fs.internal.resolve(path.subpath(0, path.getNameCount())));
            }
            return new VPath(this.fs, this.internal.resolve(path));
        }

        @Override
        public VPath resolve(String other) {
            if (other.startsWith("/")) {
                return new VPath(this.fs, this.fs.internal.resolve(Strings.stripLeading(other, '/')));
            }
            if (other.startsWith("\\")) {
                return new VPath(this.fs, this.fs.internal.resolve(Strings.stripLeading(other, '\\')));
            }
            return new VPath(this.fs, this.internal.resolve(other));
        }

        @Override
        public Path resolveSibling(Path other) {
            Objects.requireNonNull(other, "other");
            VPath parent = this.getParent();
            return parent == null ? other : parent.resolve(other);
        }

        @Override
        public boolean startsWith(Path other) {
            return this.internal.startsWith(VirtualFileSystem.unwrap0((Path)other).internal);
        }

        @Override
        public boolean endsWith(Path other) {
            return this.internal.endsWith(VirtualFileSystem.unwrap0((Path)other).internal);
        }

        @Override
        public Path resolveSibling(String other) {
            return this.resolveSibling(this.fs.getPath(other, new String[0]));
        }

        @Override
        public boolean startsWith(String other) {
            return this.startsWith(this.fs.getPath(other, new String[0]));
        }

        @Override
        public boolean endsWith(String other) {
            return this.endsWith(this.fs.getPath(other, new String[0]));
        }

        @Override
        public VPath normalize() {
            return new VPath(this.fs, this.internal.normalize());
        }

        @Override
        public String toString() {
            if (this.fs.internal.equals(this.internal)) {
                return "/";
            }
            String str = this.internal.toString();
            return this.internal.isAbsolute() ? str.substring(this.fs.internal.toString().length() + 1) : str;
        }

        @Override
        public int hashCode() {
            return this.internal.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof VPath && this.internal.equals(((VPath)obj).internal);
        }

        @Override
        public int compareTo(Path other) {
            return this.internal.compareTo(VirtualFileSystem.unwrap0((Path)other).internal);
        }

        @Override
        public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
            return this.internal.register(watcher, events, modifiers);
        }

        @Override
        public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
            return this.internal.register(watcher, events);
        }

        @Override
        public File toFile() {
            return this.internalAbsolute().toFile();
        }

        @Override
        public Iterator<Path> iterator() {
            return new Iterator<Path>(){
                private int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < this.getNameCount();
                }

                @Override
                public Path next() {
                    if (this.i < this.getNameCount()) {
                        VPath result = this.getName(this.i);
                        ++this.i;
                        return result;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new ReadOnlyFileSystemException();
                }
            };
        }
    }

    private static final class ProviderImpl
    extends FileSystemProvider {
        private ProviderImpl() {
        }

        @Override
        public String getScheme() {
            return "virtual";
        }

        @Override
        public FileSystem newFileSystem(URI uri, Map<String, ?> env) {
            this.checkUri(uri);
            return new VirtualFileSystem(Path.of(uri.getPath(), new String[0]));
        }

        @Override
        public Path getPath(URI uri) {
            this.checkUri(uri);
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            int index = schemeSpecificPart.indexOf(33);
            URI virtualUri = URI.create(schemeSpecificPart.substring(0, index));
            String path = uri.getScheme();
            if (path == null || path.charAt(0) != '/') {
                throw new IllegalArgumentException("Invalid path component");
            }
            VirtualFileSystem fs = new VirtualFileSystem(Path.of(virtualUri));
            return fs.getPath(path, new String[0]);
        }

        @Override
        public FileSystem getFileSystem(URI uri) {
            this.checkUri(uri);
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            int index = schemeSpecificPart.indexOf(33);
            URI fileUri = URI.create(schemeSpecificPart.substring(0, index));
            return new VirtualFileSystem(Path.of(fileUri));
        }

        @Override
        public void checkAccess(Path path, AccessMode ... modes) throws IOException {
            VPath vpath = VirtualFileSystem.unwrap0(path);
            vpath.internalProvider().checkAccess(vpath.internalAbsolute(), modes);
        }

        @Override
        public Path readSymbolicLink(Path link) throws IOException {
            VPath vlink = VirtualFileSystem.unwrap0(link);
            return new VPath(vlink.fs, Files.readSymbolicLink(vlink.internalAbsolute()));
        }

        @Override
        public void copy(Path src, Path target, CopyOption ... options) throws IOException {
            VPath vsrc = VirtualFileSystem.unwrap0(src);
            vsrc.internalProvider().copy(vsrc.internalAbsolute(), VirtualFileSystem.unwrap0(target).internalAbsolute(), options);
        }

        @Override
        public void createDirectory(Path path, FileAttribute<?> ... attrs) throws IOException {
            VPath vpath = VirtualFileSystem.unwrap0(path);
            vpath.internalProvider().createDirectory(vpath.internalAbsolute(), attrs);
        }

        @Override
        public void delete(Path path) throws IOException {
            VPath vpath = VirtualFileSystem.unwrap0(path);
            vpath.internalProvider().delete(vpath.internalAbsolute());
        }

        @Override
        public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
            VPath vpath = VirtualFileSystem.unwrap0(path);
            return vpath.internalProvider().getFileAttributeView(vpath.internalAbsolute(), type, options);
        }

        @Override
        public FileStore getFileStore(Path path) throws IOException {
            VPath vpath = VirtualFileSystem.unwrap0(path);
            return vpath.internalProvider().getFileStore(vpath.fs.internal);
        }

        @Override
        public boolean isHidden(Path path) throws IOException {
            VPath vpath = VirtualFileSystem.unwrap0(path);
            return vpath.internalProvider().isHidden(vpath.internalAbsolute());
        }

        @Override
        public boolean isSameFile(Path path, Path other) throws IOException {
            VPath vpath = VirtualFileSystem.unwrap0(path);
            return vpath.internalProvider().isSameFile(vpath.internalAbsolute(), VirtualFileSystem.unwrap0(other).internalAbsolute());
        }

        @Override
        public void move(Path src, Path target, CopyOption ... options) throws IOException {
            VPath vsrc = VirtualFileSystem.unwrap0(src);
            vsrc.internalProvider().move(vsrc.internalAbsolute(), VirtualFileSystem.unwrap0(target).internalAbsolute(), options);
        }

        @Override
        public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService exec, FileAttribute<?> ... attrs) throws IOException {
            VPath vpath = VirtualFileSystem.unwrap0(path);
            return vpath.internalProvider().newAsynchronousFileChannel(vpath.internalAbsolute(), options, exec, attrs);
        }

        @Override
        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            VPath vpath = VirtualFileSystem.unwrap0(path);
            return vpath.internalProvider().newByteChannel(vpath.internalAbsolute(), options, attrs);
        }

        @Override
        public DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
            final VPath vpath = VirtualFileSystem.unwrap0(path);
            Iterator<Path> it = vpath.internalProvider().newDirectoryStream(vpath.internalAbsolute(), filter).iterator();
            final Stream<Path> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false);
            return new DirectoryStream<Path>(){

                @Override
                public Iterator<Path> iterator() {
                    return stream.map(p -> new VPath(vpath2.fs, (Path)p)).iterator();
                }

                @Override
                public void close() {
                }
            };
        }

        @Override
        public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            VPath vpath = VirtualFileSystem.unwrap0(path);
            return vpath.internalProvider().newFileChannel(vpath.internalAbsolute(), options, attrs);
        }

        @Override
        public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
            VPath vpath = VirtualFileSystem.unwrap0(path);
            return vpath.internalProvider().newInputStream(vpath.internalAbsolute(), options);
        }

        @Override
        public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
            VPath vpath = VirtualFileSystem.unwrap0(path);
            return vpath.internalProvider().newOutputStream(vpath.internalAbsolute(), options);
        }

        @Override
        public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
            VPath vpath = VirtualFileSystem.unwrap0(path);
            return vpath.internalProvider().readAttributes(vpath.internalAbsolute(), type, options);
        }

        @Override
        public Map<String, Object> readAttributes(Path path, String attribute, LinkOption ... options) throws IOException {
            VPath vpath = VirtualFileSystem.unwrap0(path);
            return vpath.internalProvider().readAttributes(vpath.internalAbsolute(), attribute, options);
        }

        @Override
        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
            VPath vpath = VirtualFileSystem.unwrap0(path);
            vpath.internalProvider().setAttribute(vpath.internalAbsolute(), attribute, value, options);
        }

        private void checkUri(URI uri) {
            if (!uri.getScheme().equalsIgnoreCase(this.getScheme())) {
                throw new IllegalArgumentException("URI does not match this provider");
            }
            if (uri.getAuthority() != null) {
                throw new IllegalArgumentException("Authority component present");
            }
            if (uri.getQuery() != null) {
                throw new IllegalArgumentException("Query component present");
            }
            if (uri.getFragment() != null) {
                throw new IllegalArgumentException("Fragment component present");
            }
        }
    }

    private static final class InvalidVirtualPathException
    extends InvalidPathException {
        InvalidVirtualPathException(VirtualFileSystem fs, String input) {
            super(input, "Not within virtual root: " + fs.internal);
        }
    }
}

