/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Predicate;

public class Strings {
    public static boolean isValid(String value) {
        return value != null && !value.isBlank();
    }

    public static String requireValid(String value, String message) {
        if (Strings.isNotValid(value)) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static boolean isNotValid(String value) {
        return value == null || value.isBlank();
    }

    public static String normalizeNewLines(String value) {
        if (value == null) {
            return null;
        }
        return value.replaceAll("\r\n", "\n");
    }

    public static String normalizePath(String value) {
        if (value == null) {
            return null;
        }
        return value.replace("\\", "/");
    }

    public static String read(InputStream inputStream) {
        try {
            return new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static String padding(String pad, int maxKeyWidth, String key) {
        int keyLen = key.length();
        if (maxKeyWidth > keyLen) {
            return pad.repeat(maxKeyWidth - keyLen);
        }
        return "";
    }

    public static String stripLeading(String str, char c) {
        int index = 0;
        while (index < str.length() && str.charAt(index++) == c) {
        }
        if (index == str.length()) {
            return "";
        }
        return str.substring(index - 1);
    }

    public static String replaceWhitespaces(String str, String replacement) {
        Objects.requireNonNull(replacement, "Replacement must not be null");
        if (str == null) {
            return null;
        }
        return str.replaceAll("\\s+", replacement);
    }

    public static String replaceAll(String str, String ... replacements) {
        if (str == null || replacements == null) {
            return str;
        }
        if (replacements.length % 2 != 0) {
            throw new IllegalArgumentException("replacements should be even");
        }
        for (int i = 0; i < replacements.length; i += 2) {
            str = str.replaceAll(replacements[i], replacements[i + 1]);
        }
        return str;
    }

    public static int countWhile(Predicate<Character> predicate, String line) {
        int result = 0;
        for (char symbol : line.toCharArray()) {
            if (predicate.test(Character.valueOf(symbol))) {
                ++result;
                continue;
            }
            return result;
        }
        return result;
    }

    public static String difference(String str1, String str2) {
        if (str1 == null) {
            return str2;
        }
        if (str2 == null) {
            return str1;
        }
        int at = Strings.indexOfDifference(str1, str2);
        if (at == -1) {
            return "";
        }
        return str2.substring(at);
    }

    public static int indexOfDifference(CharSequence cs1, CharSequence cs2) {
        int i;
        if (cs1 == cs2) {
            return -1;
        }
        if (cs1 == null || cs2 == null) {
            return 0;
        }
        for (i = 0; i < cs1.length() && i < cs2.length() && cs1.charAt(i) == cs2.charAt(i); ++i) {
        }
        if (i < cs2.length() || i < cs1.length()) {
            return i;
        }
        return -1;
    }

    private Strings() {
    }
}

