/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Lists {
    private Lists() {
    }

    public static <T> List<T> filter(List<T> list, Predicate<T> predicate) {
        return list == null ? List.of() : list.stream().filter(predicate).collect(Collectors.toList());
    }

    public static <T, V> List<V> filter(Collection<T> list, Class<V> clazz) {
        return list == null ? List.of() : list.stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public static <T, V> List<T> map(Collection<V> list, Function<V, T> function) {
        return list == null ? List.of() : list.stream().map(function).collect(Collectors.toList());
    }

    public static <T, V> List<T> map(Stream<V> stream, Function<V, T> function) {
        return stream == null ? List.of() : stream.map(function).collect(Collectors.toList());
    }

    public static <T, V> List<T> flatMapStream(Collection<V> list, Function<V, Stream<T>> function) {
        return list == null ? List.of() : list.stream().flatMap(function).collect(Collectors.toList());
    }

    public static <T, V> List<T> flatMap(Collection<V> list, Function<V, Collection<T>> function) {
        return Lists.flatMapStream(list, e -> ((Collection)function.apply(e)).stream());
    }

    public static <T> List<T> flatMap(Collection<? extends Collection<T>> list) {
        return Lists.flatMapStream(list, Collection::stream);
    }

    public static <T> List<T> addAll(Collection<T> list1, Collection<T> list2) {
        LinkedList<T> list = new LinkedList<T>();
        if (list1 != null) {
            list.addAll(list1);
        }
        if (list2 != null) {
            list.addAll(list2);
        }
        return list;
    }

    @SafeVarargs
    public static <T> List<T> addAll(Collection<T> list1, T ... elements) {
        LinkedList<T> list = new LinkedList<T>();
        if (list1 != null) {
            list.addAll(list1);
        }
        Collections.addAll(list, elements);
        return list;
    }

    @SafeVarargs
    public static <T> List<T> of(T ... elements) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, elements);
        return list;
    }

    public static <T> List<T> of(Iterator<T> iterator) {
        ArrayList<T> list = new ArrayList<T>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static <T> String join(Collection<T> list, Function<T, String> function, String delimiter) {
        return list.stream().map(function).collect(Collectors.joining(delimiter));
    }

    public static <T, U> List<List<T>> groupingBy(Collection<T> list, Function<T, U> function) {
        return new ArrayList<List<T>>(list.stream().collect(Collectors.groupingBy(function)).values());
    }

    public static <T, U> Map<U, List<T>> mappedBy(List<T> list, Function<T, U> function) {
        return list.stream().collect(Collectors.groupingBy(function));
    }
}

