/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import java.util.Map;
import java.util.function.Function;

public class PropertyEvaluator {
    private PropertyEvaluator() {
    }

    public static String evaluate(String input, Function<String, String> resolver) {
        int start = input.indexOf("${");
        int end = input.indexOf("}", start);
        int index = 0;
        Object resolved = null;
        while (start >= 0 && end > 0) {
            String propValue;
            resolved = resolved == null ? input.substring(index, start) : (String)resolved + input.substring(index, start);
            String propName = input.substring(start + 2, end);
            int matchStart = 0;
            while ((matchStart = propName.indexOf("/", matchStart + 1)) > 0 && propName.charAt(matchStart - 1) == '\\') {
            }
            int matchEnd = matchStart;
            do {
                matchEnd = propName.indexOf("/", matchEnd + 1);
            } while (matchStart > 0 && propName.charAt(matchStart - 1) == '\\');
            String regexp = null;
            String replace = null;
            if (matchStart > 0 && matchEnd > matchStart) {
                regexp = propName.substring(matchStart + 1, matchEnd);
                replace = propName.substring(matchEnd + 1);
                propName = propName.substring(0, matchStart);
            }
            if ((propValue = resolver.apply(propName)) == null) {
                propValue = "";
            } else if (regexp != null && replace != null) {
                propValue = propValue.replaceAll(regexp, replace);
            }
            resolved = (String)resolved + propValue;
            index = end + 1;
            start = input.indexOf("${", index);
            end = input.indexOf("}", index);
        }
        if (resolved != null) {
            return resolved + input.substring(index);
        }
        return input;
    }

    public static String evaluate(String input, Map<String, String> properties) {
        return PropertyEvaluator.evaluate(input, properties::get);
    }
}

