/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import io.helidon.build.common.RichText;
import io.helidon.build.common.RichTextStyle;
import java.util.ServiceLoader;

public interface RichTextProvider {
    public RichText richText();

    public RichTextStyle styleOf(String ... var1);

    public static final class DefaultProvider
    implements RichTextProvider {
        static final DefaultProvider INSTANCE = new DefaultProvider();

        private DefaultProvider() {
        }

        @Override
        public RichText richText() {
            return new DefaultRichText();
        }

        @Override
        public RichTextStyle styleOf(String ... names) {
            return RichTextStyle.NONE;
        }

        private static final class DefaultRichText
        implements RichText {
            private final StringBuilder sb = new StringBuilder();

            private DefaultRichText() {
            }

            @Override
            public RichText append(CharSequence value, int start, int end) {
                this.sb.append(value, start, end);
                return this;
            }

            @Override
            public RichText append(String value) {
                this.sb.append(value);
                return this;
            }

            @Override
            public String text() {
                return this.sb.toString();
            }

            @Override
            public RichText reset() {
                return this;
            }
        }
    }

    public static final class Holder {
        public static final RichTextProvider INSTANCE = ServiceLoader.load(RichTextProvider.class, RichTextProvider.class.getClassLoader()).findFirst().orElse(DefaultProvider.INSTANCE);

        private Holder() {
        }
    }
}

