/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import io.helidon.build.common.RequirementFailure;
import java.util.Optional;

public class Requirements {
    public static <T> T requireNonNull(T instance, String message, Object ... args) {
        Requirements.require(instance != null, message, args);
        return instance;
    }

    public static void require(boolean condition, String message, Object ... args) {
        if (!condition) {
            Requirements.failed(message, args);
        }
    }

    public static void failed(String message, Object ... args) {
        throw new RequirementFailure(message, args);
    }

    public static Optional<RequirementFailure> toFailure(Throwable error) {
        if (error == null) {
            return Optional.empty();
        }
        if (error instanceof RequirementFailure) {
            return Optional.of((RequirementFailure)error);
        }
        return Requirements.toFailure(error.getCause()).or(Optional::empty);
    }

    private Requirements() {
    }
}

