/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class Time {
    private static final DateTimeFormatter ZONED_DATE_FORMATTER = DateTimeFormatter.ofPattern("MM-dd-yyyy kk:mm:ss z");
    private static final ZoneId ZONE = ZoneId.systemDefault();

    public static String currentDateTime() {
        return Time.toDateTime(System.currentTimeMillis());
    }

    public static String toDateTime(long millis) {
        return Time.toDateTime(Instant.ofEpochMilli(millis));
    }

    public static String toDateTime(FileTime fileTime) {
        return Time.toDateTime(fileTime.toInstant());
    }

    public static String toDateTime(Instant instant) {
        ZonedDateTime time = ZonedDateTime.ofInstant(instant, ZONE);
        return ZONED_DATE_FORMATTER.format(time);
    }

    private Time() {
    }
}

