/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import io.helidon.build.common.LineReader;
import io.helidon.build.common.PrintStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.function.Function;
import java.util.function.Predicate;

final class ConsoleRecorder {
    private static final String EOL = System.lineSeparator();
    private final StringBuilder capturedOutput = new StringBuilder();
    private final StringBuilder capturedStdOut = new StringBuilder();
    private final StringBuilder capturedStdErr = new StringBuilder();
    private final Predicate<String> filter;
    private final Function<String, String> transform;
    private final boolean capturing;
    private final PrintStream stdOut;
    private final PrintStream stdErr;
    private LineReader stdOutReader;
    private LineReader stdErrReader;
    private final boolean autoEol;

    ConsoleRecorder(PrintStream stdOut, PrintStream stdErr, Predicate<String> filter, Function<String, String> transform, boolean recording, boolean autoEol) {
        this.filter = filter;
        this.transform = transform;
        this.capturing = recording;
        this.stdOut = PrintStreams.delegate(stdOut, (printer, str) -> this.print((PrintStream)printer, (String)str, this.capturedStdOut));
        this.stdErr = PrintStreams.delegate(stdErr, (printer, str) -> this.print((PrintStream)printer, (String)str, this.capturedStdErr));
        this.autoEol = autoEol;
    }

    void start(InputStream outStream, InputStream errStream) {
        if (this.stdOutReader != null || this.stdErrReader != null) {
            throw new IllegalStateException("Already started");
        }
        this.stdOutReader = new LineReader(outStream, this.stdOut::print, this.stdOut::flush);
        this.stdErrReader = new LineReader(errStream, this.stdErr::print, this.stdErr::flush);
    }

    void stop() {
        this.stdOutReader = null;
        this.stdErrReader = null;
    }

    boolean tick() throws IOException {
        boolean ticked = false;
        if (this.stdOutReader != null && this.stdOutReader.tick()) {
            ticked = true;
        }
        if (this.stdErrReader != null && this.stdErrReader.tick()) {
            ticked = true;
        }
        return ticked;
    }

    String capturedOutput() {
        return this.capturedOutput.toString();
    }

    String capturedStdOut() {
        return this.capturedStdOut.toString();
    }

    String capturedStdErr() {
        return this.capturedStdErr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(PrintStream printer, String str, StringBuilder capture) {
        Object line = str;
        if (this.autoEol) {
            line = (String)line + EOL;
        }
        if (this.filter.test(str)) {
            printer.print(this.transform.apply((String)line));
        }
        if (this.capturing) {
            StringBuilder stringBuilder = this.capturedOutput;
            synchronized (stringBuilder) {
                this.capturedOutput.append((String)line);
                capture.append((String)line);
            }
        }
    }

    void drain() {
        if (this.stdOutReader != null) {
            this.stdOutReader.drain();
        }
        if (this.stdErrReader != null) {
            this.stdErrReader.drain();
        }
    }
}

