/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.logging;

import io.helidon.build.common.RichTextRenderer;
import io.helidon.build.common.logging.LogFormatter;
import io.helidon.build.common.logging.LogLevel;
import java.io.PrintWriter;
import java.io.StringWriter;

final class DefaultFormatter
extends LogFormatter {
    static final DefaultFormatter INSTANCE = new DefaultFormatter();
    private static final String EOL = System.getProperty("line.separator");

    private DefaultFormatter() {
    }

    @Override
    public String formatEntry(LogLevel level, Throwable thrown, String message, Object ... args) {
        String rendered = RichTextRenderer.render(message, args);
        String trace = DefaultFormatter.trace(level, thrown);
        if (trace == null) {
            return rendered;
        }
        if (rendered.isEmpty()) {
            return trace;
        }
        return rendered + EOL + trace;
    }

    private static String trace(LogLevel level, Throwable thrown) {
        if (thrown != null) {
            if (DefaultFormatter.isDebug(level)) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                try {
                    thrown.printStackTrace(pw);
                    String string = sw.toString();
                    pw.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            pw.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {}
                }
            } else if (DefaultFormatter.isVerbose(level)) {
                return thrown.toString();
            }
        }
        return null;
    }
}

