/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class InputStreams {
    private static final byte[] BUFFER = new byte[262144];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transfer(InputStream in, OutputStream out) throws IOException {
        byte[] byArray = BUFFER;
        synchronized (BUFFER) {
            try (InputStream data = in;){
                int bytesRead;
                while ((bytesRead = data.read(BUFFER)) != -1) {
                    out.write(BUFFER, 0, bytesRead);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static String toString(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStreams.transfer(in, out);
        return InputStreams.toString(out);
    }

    public static String toString(ByteArrayOutputStream out) {
        return out.toString(StandardCharsets.UTF_8);
    }

    public static PrintStream toPrintStream(OutputStream out, boolean autoFlush) {
        try {
            return new PrintStream(out, autoFlush, StandardCharsets.UTF_8.displayName());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> toLines(InputStream in) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line;
            ArrayList<String> result = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    private InputStreams() {
    }
}

