/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import io.helidon.build.common.logging.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;

public class Proxies {
    private static final String HTTP_PROXY_VAR = "HTTP_PROXY";
    private static final String HTTPS_PROXY_VAR = "HTTPS_PROXY";
    private static final String NO_PROXY_VAR = "NO_PROXY";
    private static final String HTTPS_PREFIX = "HTTPS";
    private static final String PROXY_HOST_PROP_SUFFIX = ".proxyHost";
    private static final String PROXY_PORT_PROP_SUFFIX = ".proxyPort";
    private static final String HTTP_PROP_PREFIX = "http";
    private static final String HTTPS_PROP_PREFIX = "https";
    private static final String NO_PROXY_NEEDS_WILDCARD_PREFIX = ".";
    private static final String NO_PROXY_WILDCARD = "*";
    private static final String NO_PROXY_VAR_SEP = ",";
    private static final String NO_PROXY_PROP_SEP = "|";
    private static final String HTTP_NON_PROXY_PROP = "http.nonProxyHosts";
    private static final String HTTPS_NON_PROXY_PROP = "https.nonProxyHosts";
    private static final List<String> PROXY_PROPS = List.of("http.proxyHost", "http.proxyPort", "http.nonProxyHosts", "https.proxyHost", "https.proxyPort", "https.nonProxyHosts");
    private static final AtomicReference<List<String>> PROXY_ARGS = new AtomicReference();

    public static void setProxyPropertiesFromEnv() {
        Proxies.setProxyPropertiesFrom(System.getenv(), System.getProperties());
    }

    public static List<String> javaProxyArgs() {
        List<String> args = PROXY_ARGS.get();
        if (args == null) {
            args = Proxies.collectPropertyArgs();
            PROXY_ARGS.set(args);
        }
        return args;
    }

    public static List<String> proxyProperties() {
        return PROXY_PROPS;
    }

    static List<String> collectPropertyArgs() {
        ArrayList<String> args = new ArrayList<String>();
        PROXY_PROPS.forEach(key -> {
            String value = System.getProperty(key);
            if (value != null) {
                args.add("-D" + key + "=" + value);
            }
        });
        return args;
    }

    static void setProxyPropertiesFrom(Map<String, String> env, Properties properties) {
        Proxies.setProxy(HTTP_PROXY_VAR, env, properties);
        Proxies.setProxy(HTTPS_PROXY_VAR, env, properties);
        Proxies.setNoProxy(NO_PROXY_VAR, env, properties);
    }

    private static void setNoProxy(String envVarName, Map<String, String> env, Properties properties) {
        String value = Proxies.envVar(envVarName, env);
        if (value != null) {
            StringBuilder sb = new StringBuilder();
            for (String host : value.split(NO_PROXY_VAR_SEP)) {
                if (sb.length() > 0) {
                    sb.append(NO_PROXY_PROP_SEP);
                }
                if (host.startsWith(NO_PROXY_NEEDS_WILDCARD_PREFIX)) {
                    sb.append(NO_PROXY_WILDCARD);
                }
                sb.append(host);
            }
            Proxies.setProperty(HTTP_NON_PROXY_PROP, sb.toString(), properties);
            Proxies.setProperty(HTTPS_NON_PROXY_PROP, sb.toString(), properties);
        }
    }

    private static void setProxy(String envVarName, Map<String, String> env, Properties properties) {
        String value = Proxies.envVar(envVarName, env);
        if (value != null) {
            String[] split = value.split(":");
            String host = null;
            String port = null;
            if (split.length == 3) {
                host = split[1];
                port = split[2];
                if (host.startsWith("//")) {
                    host = host.substring(2);
                }
            } else if (split.length == 2) {
                host = split[0];
                port = split[1];
            }
            if (host != null && port != null) {
                String protocol = envVarName.startsWith(HTTPS_PREFIX) ? HTTPS_PROP_PREFIX : HTTP_PROP_PREFIX;
                Proxies.setProperty(protocol + PROXY_HOST_PROP_SUFFIX, host, properties);
                Proxies.setProperty(protocol + PROXY_PORT_PROP_SUFFIX, port, properties);
            }
        }
    }

    private static void setProperty(String name, String value, Properties properties) {
        String existing = properties.getProperty(name);
        if (existing == null) {
            Log.debug("Setting system entry \"%s\" to \"%s\"", name, value);
            properties.setProperty(name, value);
        } else {
            Log.debug("Skip set system entry \"%s\" to \"%s\". Already set to \"%s\"", name, value, existing);
        }
    }

    private static String envVar(String name, Map<String, String> env) {
        String value = env.get(name);
        if (value == null) {
            value = env.get(name.toLowerCase(Locale.ENGLISH));
        }
        return value;
    }

    private Proxies() {
    }
}

