/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import java.util.Objects;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.project.MavenProject;

final class ArtifactEntry {
    private final String type;
    private final String extension;
    private final String classifier;
    private final String file;
    private final boolean includesDependencies;
    private final String language;
    private final boolean addedToClasspath;

    ArtifactEntry(String file, String type, String extension, String classifier, String language, boolean includesDependencies, boolean addedToClasspath) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.extension = Objects.requireNonNull(extension, "extension is null");
        this.classifier = classifier != null && classifier.isEmpty() ? null : classifier;
        this.file = Objects.requireNonNull(file, "file is null");
        this.language = language != null && language.isEmpty() ? null : language;
        this.includesDependencies = includesDependencies;
        this.addedToClasspath = addedToClasspath;
    }

    String file() {
        return this.file;
    }

    String classifier() {
        return this.classifier;
    }

    String extension() {
        return this.extension;
    }

    String type() {
        return this.type;
    }

    String language() {
        return this.language;
    }

    boolean addedToClasspath() {
        return this.addedToClasspath;
    }

    boolean includesDependencies() {
        return this.includesDependencies;
    }

    static ArtifactEntry create(Artifact artifact, MavenProject project) {
        if (artifact == null || artifact.getFile() == null) {
            return null;
        }
        ArtifactHandler handler = artifact.getArtifactHandler();
        String file = project.getModel().getProjectDirectory().toPath().resolve(project.getModel().getBuild().getDirectory()).relativize(artifact.getFile().toPath()).toString();
        return new ArtifactEntry(file, artifact.getType(), handler.getExtension(), artifact.getClassifier(), handler.getLanguage(), handler.isIncludesDependencies(), handler.isAddedToClasspath());
    }

    Artifact toArtifact(MavenProject project) {
        DefaultArtifactHandler handler = new DefaultArtifactHandler(this.type);
        handler.setExtension(this.extension);
        handler.setLanguage(this.language);
        handler.setIncludesDependencies(this.includesDependencies);
        handler.setAddedToClasspath(this.addedToClasspath);
        DefaultArtifact artifact = new DefaultArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), "compile", this.type, this.classifier, (ArtifactHandler)handler);
        artifact.setFile(project.getModel().getProjectDirectory().toPath().resolve(project.getModel().getBuild().getDirectory()).resolve(this.file).toFile());
        return artifact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactEntry that = (ArtifactEntry)o;
        return this.includesDependencies == that.includesDependencies && this.addedToClasspath == that.addedToClasspath && Objects.equals(this.type, that.type) && Objects.equals(this.extension, that.extension) && Objects.equals(this.classifier, that.classifier) && Objects.equals(this.file, that.file) && Objects.equals(this.language, that.language);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.extension, this.classifier, this.file, this.includesDependencies, this.language, this.addedToClasspath);
    }

    public String toString() {
        return "ArtifactEntry{type='" + this.type + "', extension='" + this.extension + "', classifier='" + (this.classifier == null ? "" : this.classifier) + "', file='" + this.file + "', includesDependencies=" + this.includesDependencies + ", language='" + (this.language == null ? "" : this.language) + "', addedToClasspath=" + this.addedToClasspath + "}";
    }
}

