/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.common.xml.XMLElement;
import io.helidon.build.maven.cache.ConfigHelper;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.SessionScoped;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.logging.Logger;

@Named
@SessionScoped
public class ConfigResolver {
    @Inject
    private LifecycleExecutionPlanCalculator executionPlanCalculator;
    @Inject
    private Logger logger;
    @Inject
    private MavenSession session;

    public XMLElement resolve(MojoExecution execution, MavenProject project) {
        try {
            MojoExecution executionCopy = this.copyExecution(execution);
            MavenSession sessionCopy = this.session.clone();
            sessionCopy.setCurrentProject(project);
            this.executionPlanCalculator.setupMojoExecution(sessionCopy, project, executionCopy);
            return this.resolve0(executionCopy, sessionCopy);
        }
        catch (LifecycleNotFoundException | LifecyclePhaseNotFoundException | InvalidPluginDescriptorException | MojoNotFoundException | PluginDescriptorParsingException | PluginNotFoundException | PluginResolutionException | NoPluginFoundForPrefixException | PluginVersionResolutionException ex) {
            this.logger.error("Unable to configure mojo: " + execution, ex);
            return null;
        }
    }

    private MojoExecution copyExecution(MojoExecution execution) {
        MojoExecution copy = new MojoExecution(execution.getPlugin(), execution.getGoal(), execution.getExecutionId());
        copy.setLifecyclePhase(execution.getLifecyclePhase());
        copy.setMojoDescriptor(execution.getMojoDescriptor());
        execution.getForkedExecutions().forEach((arg_0, arg_1) -> ((MojoExecution)copy).setForkedExecutions(arg_0, arg_1));
        return copy;
    }

    private XMLElement resolve0(MojoExecution execution, MavenSession session) {
        final ExpressionEvaluator evaluator = new ExpressionEvaluator(session, execution);
        XMLElement config = ConfigHelper.toXMLElement(execution.getConfiguration());
        config.visit(new XMLElement.Visitor(){

            public void visitElement(XMLElement elt) {
                elt.attributes().entrySet().forEach(e -> e.setValue(ConfigResolver.this.evaluateExpression(evaluator, (String)e.getValue())));
                String value = elt.value();
                if (value != null) {
                    elt.value(ConfigResolver.this.evaluateExpression(evaluator, value));
                }
            }
        });
        return config;
    }

    private String evaluateExpression(ExpressionEvaluator evaluator, String value) {
        return Optional.ofNullable(value).map(v -> {
            try {
                Object result = evaluator.evaluate((String)v);
                if (result instanceof String) {
                    return (String)result;
                }
                return v;
            }
            catch (ExpressionEvaluationException e) {
                this.logger.error("Unable to evaluate expression: " + v, (Throwable)e);
                return v;
            }
        }).orElse("");
    }

    private static final class ExpressionEvaluator
    extends PluginParameterExpressionEvaluator {
        private final String rootDir;

        ExpressionEvaluator(MavenSession session, MojoExecution mojoExecution) {
            super(session, mojoExecution);
            this.rootDir = session.getRequest().getMultiModuleProjectDirectory().toPath().toString();
        }

        public Object evaluate(String expr, Class<?> type) throws ExpressionEvaluationException {
            Object val = super.evaluate(expr, type);
            if (val instanceof String) {
                return ((String)val).replace(this.rootDir, "#{root.dir}");
            }
            return val;
        }
    }
}

