/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.common.SourcePath;
import io.helidon.build.maven.cache.CacheConfig;
import io.helidon.build.maven.cache.CacheConfigManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.SessionScoped;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.graph.DefaultProjectDependencyGraph;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.plexus.logging.Logger;

@Named
@SessionScoped
public class ReactorManager {
    @Inject
    private MavenSession session;
    @Inject
    private CacheConfigManager configManager;
    @Inject
    private Logger logger;

    public void afterProjectsRead() {
        if (this.disabled()) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Processing reactor...");
        }
        List allPaths = this.session.getAllProjects().stream().map(this::projectPath).collect(Collectors.toList());
        HashSet selectPaths = new HashSet();
        HashMap<String, List> moduleSets = new HashMap<String, List>();
        CacheConfig.ReactorRule reactorRule = this.configManager.reactorRule();
        String moduleSetName = this.configManager.cacheConfig().moduleSet();
        for (CacheConfig.ModuleSet moduleSet : reactorRule.moduleSets()) {
            List unselected = allPaths.stream().filter(p -> !selectPaths.contains(p)).collect(Collectors.toList());
            List paths = SourcePath.filter(unselected, moduleSet.includes(), moduleSet.excludes());
            selectPaths.addAll(paths);
            moduleSets.put(moduleSet.name(), paths);
        }
        List moduleSet = (List)moduleSets.get(moduleSetName);
        if (moduleSet == null) {
            throw new IllegalStateException("ModuleSet not found: " + moduleSetName);
        }
        if (moduleSet.isEmpty()) {
            throw new IllegalStateException("Resolved moduleSet is empty: " + moduleSetName);
        }
        List projects = this.session.getAllProjects().stream().filter(p -> moduleSet.contains(this.projectPath((MavenProject)p))).collect(Collectors.toList());
        try {
            DefaultProjectDependencyGraph graph = new DefaultProjectDependencyGraph(this.session.getAllProjects(), projects);
            this.session.setProjects(graph.getSortedProjects());
            this.session.setAllProjects(graph.getAllProjects());
            this.session.setProjectDependencyGraph((ProjectDependencyGraph)graph);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void afterSessionStart() {
        if (this.disabled()) {
            return;
        }
        CacheConfig.ReactorRule reactorRule = this.configManager.reactorRule();
        String moduleSet = this.configManager.cacheConfig().moduleSet();
        this.logger.info(String.format("Filtering modules {reactorRule=%s, moduleSet=%s}", reactorRule.name(), moduleSet));
        if (!reactorRule.profiles().isEmpty()) {
            this.logger.info("Activating profiles: " + reactorRule.profiles());
            reactorRule.profiles().forEach(arg_0 -> ((MavenExecutionRequest)this.session.getRequest()).addActiveProfile(arg_0));
            ProjectBuildingRequest pbr = this.session.getProjectBuildingRequest();
            HashSet profileIds = new HashSet(pbr.getActiveProfileIds());
            pbr.setActiveProfileIds(new ArrayList(profileIds));
        }
    }

    private boolean disabled() {
        CacheConfig cacheConfig = this.configManager.cacheConfig();
        CacheConfig.ReactorRule reactorRule = this.configManager.reactorRule();
        String moduleSetName = cacheConfig.moduleSet();
        return !cacheConfig.enabled() || reactorRule == null || moduleSetName == null || moduleSetName.isEmpty();
    }

    private SourcePath projectPath(MavenProject project) {
        Path path = this.root().relativize(project.getFile().toPath().toAbsolutePath());
        return new SourcePath(path);
    }

    private Path root() {
        return this.session.getRequest().getMultiModuleProjectDirectory().toPath();
    }
}

