/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.maven.cache.CacheConfig;
import io.helidon.build.maven.cache.CacheConfigManager;
import io.helidon.build.maven.cache.ConfigDiff;
import io.helidon.build.maven.cache.DelegatingExecutionListener;
import io.helidon.build.maven.cache.ProjectExecutionManager;
import io.helidon.build.maven.cache.ProjectExecutionPlan;
import io.helidon.build.maven.cache.ProjectStateManager;
import io.helidon.build.maven.cache.ProjectStateStatus;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.SessionScoped;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;

@Named
@SessionScoped
public class LifecycleManager {
    @Inject
    private ProjectStateManager stateManager;
    @Inject
    private ProjectExecutionManager executionManager;
    @Inject
    private CacheConfigManager configManager;
    @Inject
    private MavenSession session;
    @Inject
    private Logger logger;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public void afterProjectsRead() {
        MavenExecutionRequest request = this.session.getRequest();
        request.setExecutionListener((ExecutionListener)new ExecutionListenerImpl(request.getExecutionListener()));
    }

    private void initState(MavenSession session) {
        if (this.initialized.compareAndSet(false, true)) {
            if (session.getGoals().contains("clean")) {
                this.logger.debug("Clean requested, state is ignored");
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Processing state files...");
                }
                this.stateManager.states().forEach((p, stateStatus) -> {
                    if (stateStatus.code() != 1) {
                        if (stateStatus.code() == 0) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug(String.format("[%s:%s] - applying state", p.getGroupId(), p.getArtifactId()));
                            }
                            stateStatus.state().apply((MavenProject)p, session);
                        }
                        this.executionManager.processExecutions((MavenProject)p, (ProjectStateStatus)stateStatus);
                    }
                });
                this.logger.info(String.format("Loaded %s state file(s)", this.stateManager.loaded()));
            }
            this.latch.countDown();
        } else {
            this.awaitInit();
        }
    }

    private void awaitInit() {
        try {
            this.latch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private final class ExecutionListenerImpl
    extends DelegatingExecutionListener {
        ExecutionListenerImpl(ExecutionListener delegate) {
            super(delegate);
        }

        @Override
        public void projectStarted(ExecutionEvent event) {
            super.projectStarted(event);
            LifecycleManager.this.initState(event.getSession());
            MavenProject project = event.getProject();
            CacheConfig.LifecycleConfig lifeCycleConfig = LifecycleManager.this.configManager.lifecycleConfig(project);
            ProjectExecutionPlan plan = LifecycleManager.this.executionManager.plan(project);
            if (!lifeCycleConfig.enabled()) {
                LifecycleManager.this.logger.info("Cache is disabled");
            } else if (plan == null) {
                LifecycleManager.this.logger.info("State is not available");
            } else if (plan.hasInvalidDownstream()) {
                LifecycleManager.this.logger.info("Downstream state(s) not available, state is ignored");
            } else if (!plan.hasFileChanges() && plan.allCached()) {
                LifecycleManager.this.logger.info("All executions are cached! (fast-forward)");
            } else if (plan.hasFileChanges()) {
                LifecycleManager.this.logger.info("File changes detected, state is ignored");
                ProjectStateStatus stateStatus = plan.stateStatus();
                stateStatus.state().projectFiles().diff(stateStatus.projectFiles()).forEach(diff -> LifecycleManager.this.logger.info("  +- " + diff.asString()));
            } else {
                plan.executionStatuses().stream().filter(s -> !s.isNew()).forEach(s -> {
                    LifecycleManager.this.logger.info(s.toString());
                    if (s.isDiff()) {
                        List<ConfigDiff> diffs = s.diffs();
                        for (ConfigDiff diff : diffs) {
                            LifecycleManager.this.logger.info("           +- " + diff.asString());
                        }
                    }
                });
            }
        }

        @Override
        public void mojoSucceeded(ExecutionEvent event) {
            super.mojoSucceeded(event);
            LifecycleManager.this.executionManager.recordExecution(event.getMojoExecution(), event.getProject());
        }

        @Override
        public void projectSucceeded(ExecutionEvent event) {
            super.projectSucceeded(event);
            MavenProject project = event.getProject();
            if (LifecycleManager.this.configManager.lifecycleConfig(project).enabled()) {
                LifecycleManager.this.stateManager.save(project);
            }
        }
    }
}

