/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.maven.cache.CacheConfig;
import io.helidon.build.maven.cache.CacheConfigManager;
import io.helidon.build.maven.cache.ConfigResolver;
import io.helidon.build.maven.cache.ExecutionEntry;
import io.helidon.build.maven.cache.ProjectExecutionPlan;
import io.helidon.build.maven.cache.ProjectStateStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.SessionScoped;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleMappingDelegate;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;

@Named
@SessionScoped
public class ProjectExecutionManager {
    private final Map<MavenProject, List<ExecutionEntry>> recordedExecutions = new ConcurrentHashMap<MavenProject, List<ExecutionEntry>>();
    private final Map<MavenProject, ProjectExecutionPlan> executionPlans = new HashMap<MavenProject, ProjectExecutionPlan>();
    @Inject
    private DefaultLifecycles defaultLifecycles;
    @Inject
    @Named(value="default")
    private LifecycleMappingDelegate standardLifecycleDelegate;
    @Inject
    private Map<String, LifecycleMappingDelegate> lifecycleDelegates;
    @Inject
    private ConfigResolver configResolver;
    @Inject
    private Logger logger;
    @Inject
    private MavenSession session;
    @Inject
    private CacheConfigManager configManager;
    private final ReentrantLock lock = new ReentrantLock();

    public void processExecutions(MavenProject project, ProjectStateStatus stateStatus) {
        if (stateStatus.code() == 2 || stateStatus.code() == 3) {
            this.executionPlans.put(project, new ProjectExecutionPlan(stateStatus, List.of()));
            return;
        }
        List<ExecutionEntry> executions = this.resolveExecutions(project);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("[%s:%s] - executions in the current life-cycle: \n  %s", project.getGroupId(), project.getArtifactId(), executions.stream().map(ExecutionEntry::name).collect(Collectors.joining("\n  "))));
        }
        ProjectExecutionPlan execPlan = new ProjectExecutionPlan(stateStatus, executions);
        this.executionPlans.put(project, execPlan);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("[%s:%s] - execution statuses:\n  %s", project.getGroupId(), project.getArtifactId(), execPlan.executionStatuses().stream().map(s -> {
                Object str = s.toString();
                if (s.isDiff()) {
                    str = (String)str + "\n" + s.diffs().stream().map(d -> "             +- " + d.asString()).collect(Collectors.joining());
                }
                return str;
            }).collect(Collectors.joining("\n  "))));
        }
        project.getBuild().getPlugins().forEach(plugin -> this.removePluginExecutions((Plugin)plugin, execPlan.cachedExecutions()));
    }

    public ProjectExecutionPlan plan(MavenProject project) {
        return this.executionPlans.get(project);
    }

    public void recordExecution(MojoExecution execution, MavenProject project) {
        ExecutionEntry executionRecord = ExecutionEntry.create(execution, this.configResolver.resolve(execution, project));
        if (!this.isCleanExecution(project, executionRecord) && !MojoExecution.Source.CLI.equals((Object)execution.getSource())) {
            this.recordedExecutions.computeIfAbsent(project, p -> new ArrayList()).add(executionRecord);
        }
    }

    public List<ExecutionEntry> recordedExecutions(MavenProject project) {
        return this.recordedExecutions.getOrDefault(project, List.of());
    }

    private List<ExecutionEntry> resolveExecutions(MavenProject project) {
        CacheConfig.LifecycleConfig lifecycleConfig = this.configManager.lifecycleConfig(project);
        List<String> includes = lifecycleConfig.executionsIncludes();
        List<String> excludes = lifecycleConfig.executionsExcludes();
        return this.session.getGoals().stream().filter(phase -> !phase.equals("clean")).flatMap(phase -> this.resolvePhase(project, (String)phase).stream()).map(exec -> ExecutionEntry.create(exec, this.configResolver.resolve((MojoExecution)exec, project))).filter(exec -> exec.match(includes, excludes)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MojoExecution> resolvePhase(MavenProject project, String phase) {
        try {
            this.lock.lock();
            Lifecycle lifecycle = this.defaultLifecycles.get(phase);
            if (lifecycle == null) {
                List<MojoExecution> list = List.of();
                return list;
            }
            LifecycleMappingDelegate lifecycleDelegate = null;
            if (Arrays.binarySearch(DefaultLifecycles.STANDARD_LIFECYCLES, lifecycle.getId()) < 0) {
                lifecycleDelegate = this.lifecycleDelegates.get(lifecycle.getId());
            }
            if (lifecycleDelegate == null) {
                lifecycleDelegate = this.standardLifecycleDelegate;
            }
            List<MojoExecution> list = lifecycleDelegate.calculateLifecycleMappings(this.session, project, lifecycle, phase).entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
            return list;
        }
        catch (InvalidPluginDescriptorException | MojoNotFoundException | PluginDescriptorParsingException | PluginNotFoundException | PluginResolutionException e2) {
            this.logger.warn("Unable to resolve mojos for phase: " + phase, e2);
            List<MojoExecution> list = List.of();
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isCleanExecution(MavenProject project, ExecutionEntry execution) {
        return this.resolvePhase(project, "clean").stream().map(e -> ExecutionEntry.create(e, null)).anyMatch(e -> e.matches(execution));
    }

    private void removePluginExecutions(Plugin plugin, List<ExecutionEntry> executions) {
        plugin.getExecutions().forEach(pluginExec -> {
            Iterator it = pluginExec.getGoals().iterator();
            while (it.hasNext()) {
                String goal = (String)it.next();
                if (!executions.stream().anyMatch(e -> e.matches(plugin, goal, pluginExec.getId()))) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Skipping: " + plugin.getId() + "@" + pluginExec.getId());
                }
                it.remove();
            }
        });
        plugin.getExecutions().removeIf(pluginExecution -> pluginExecution.getGoals().isEmpty());
    }
}

