/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.common.SourcePath;
import io.helidon.build.common.xml.XMLElement;
import io.helidon.build.maven.cache.CacheConfig;
import io.helidon.build.maven.cache.CacheConfigManager;
import io.helidon.build.maven.cache.ProjectFilesDiffs;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;

final class ProjectFiles {
    private final int filesCount;
    private final long lastModified;
    private final String checksum;
    private final Map<String, String> allChecksums;

    ProjectFiles(int filesCount, long lastModified, String checksum, Map<String, String> allChecksums) {
        this.filesCount = filesCount;
        this.lastModified = lastModified;
        this.checksum = checksum;
        this.allChecksums = allChecksums == null ? Map.of() : allChecksums;
    }

    int filesCount() {
        return this.filesCount;
    }

    long lastModified() {
        return this.lastModified;
    }

    String checksum() {
        return this.checksum;
    }

    Map<String, String> allChecksums() {
        return this.allChecksums;
    }

    ProjectFilesDiffs diff(ProjectFiles projectFiles) {
        return new ProjectFilesDiffs(this, projectFiles);
    }

    static ProjectFiles fromXml(XMLElement elt) {
        int filesCount = 0;
        long lastModified = 0L;
        String checksum = null;
        HashMap<String, String> allChecksums = new HashMap<String, String>();
        if (elt != null) {
            String lastModifiedAttr;
            String filesCountAttr = (String)elt.attributes().get("count");
            if (filesCountAttr != null) {
                filesCount = Integer.parseInt(filesCountAttr);
            }
            if ((lastModifiedAttr = (String)elt.attributes().get("last-modified")) != null) {
                lastModified = Long.parseLong(lastModifiedAttr);
            }
            checksum = (String)elt.attributes().get("checksum");
            for (XMLElement fileElt : elt.children("file")) {
                String fsum = (String)fileElt.attributes().get("checksum");
                String fpath = fileElt.value();
                if (fsum == null || fsum.isEmpty() || fpath == null || fpath.isEmpty()) continue;
                allChecksums.put(fpath, fsum);
            }
        }
        return new ProjectFiles(filesCount, lastModified, checksum, allChecksums);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectFiles that = (ProjectFiles)o;
        return this.filesCount == that.filesCount && (this.lastModified == that.lastModified || Objects.equals(this.checksum, that.checksum));
    }

    public int hashCode() {
        return Objects.hash(this.filesCount, this.lastModified, this.checksum);
    }

    static ProjectFiles of(MavenProject project, CacheConfigManager configManager) throws IOException {
        CacheConfig cacheConfig = configManager.cacheConfig();
        CacheConfig.LifecycleConfig lifeCycleConfig = configManager.lifecycleConfig(project);
        Path projectDir = project.getModel().getProjectDirectory().toPath();
        List<Path> modules = ProjectFiles.allModules(project).stream().map(projectDir::resolve).map(p -> Files.isDirectory(p, new LinkOption[0]) ? p : p.getParent()).collect(Collectors.toList());
        Path buildDir = project.getModel().getProjectDirectory().toPath().resolve(project.getModel().getBuild().getDirectory());
        FileVisitorImpl visitor = new FileVisitorImpl(projectDir, buildDir, modules, lifeCycleConfig.projectFilesExcludes());
        Files.walkFileTree(projectDir, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, visitor);
        long lastModified = 0L;
        HashMap<String, String> fileChecksums = new HashMap<String, String>();
        MD5 md5 = cacheConfig.enableChecksums() ? new MD5() : null;
        Collections.sort(visitor.files);
        for (String f : visitor.files) {
            Path file = projectDir.resolve(f);
            long lm = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
            if (lastModified < lm) {
                lastModified = lm;
            }
            if (cacheConfig.includeAllChecksums()) {
                fileChecksums.put(f, MD5.checksum(file));
            }
            if (md5 == null) continue;
            md5.update(file);
        }
        String checksums = md5 != null ? md5.toHexString() : null;
        return new ProjectFiles(visitor.files.size(), lastModified, checksums, fileChecksums);
    }

    private static Set<String> allModules(MavenProject project) {
        HashSet<String> modules = new HashSet<String>(project.getModules());
        for (Profile profile : project.getModel().getProfiles()) {
            modules.addAll(profile.getModules());
        }
        return modules;
    }

    private static final class FileVisitorImpl
    implements FileVisitor<Path> {
        private final Path projectDir;
        private final Path buildDir;
        private final List<Path> moduleDirs;
        private final List<String> excludes;
        private final List<String> files = new ArrayList<String>();

        FileVisitorImpl(Path projectDir, Path buildDir, List<Path> moduleDirs, List<String> excludes) {
            this.projectDir = projectDir;
            this.buildDir = buildDir;
            this.moduleDirs = moduleDirs;
            this.excludes = excludes;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            if (this.moduleDirs.contains(dir) || dir.startsWith(this.buildDir)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            if (new SourcePath(this.projectDir, file).matches(null, this.excludes)) {
                this.files.add(this.projectDir.relativize(file).toString());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }

    private static final class MD5 {
        private static final char[] HEX_CODE = "0123456789ABCDEF".toCharArray();
        private static volatile ByteBuffer buffer;
        private final MessageDigest md;

        MD5() {
            try {
                this.md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new RuntimeException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        MD5 update(Path file) throws IOException {
            RandomAccessFile raf = new RandomAccessFile(file.toFile(), "r");
            FileChannel fc = raf.getChannel();
            if (buffer == null) {
                Class<MD5> clazz = MD5.class;
                // MONITORENTER : io.helidon.build.maven.cache.ProjectFiles$MD5.class
                if (buffer == null) {
                    buffer = ByteBuffer.allocate(4096);
                }
                // MONITOREXIT : clazz
            }
            while (true) {
                if (fc.read(buffer) <= 0) {
                    buffer.clear();
                    fc.close();
                    raf.close();
                    return this;
                }
                buffer.flip();
                this.md.update(buffer);
                buffer.clear();
            }
        }

        String toHexString() {
            byte[] bytes = this.md.digest();
            StringBuilder r = new StringBuilder(bytes.length * 2);
            for (byte b : bytes) {
                r.append(HEX_CODE[b >> 4 & 0xF]);
                r.append(HEX_CODE[b & 0xF]);
            }
            return r.toString();
        }

        static String checksum(Path file) throws IOException {
            return new MD5().update(file).toHexString();
        }
    }
}

