/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.common.LazyValue;
import io.helidon.build.common.Lists;
import io.helidon.build.common.xml.XMLException;
import io.helidon.build.maven.cache.CacheConfig;
import io.helidon.build.maven.cache.CacheConfigManager;
import io.helidon.build.maven.cache.ExecutionEntry;
import io.helidon.build.maven.cache.ProjectExecutionManager;
import io.helidon.build.maven.cache.ProjectFiles;
import io.helidon.build.maven.cache.ProjectState;
import io.helidon.build.maven.cache.ProjectStateStatus;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.SessionScoped;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;

@Named
@SessionScoped
public class ProjectStateManager {
    @Inject
    private ProjectExecutionManager executionManager;
    @Inject
    private CacheConfigManager configManager;
    @Inject
    private MavenSession session;
    @Inject
    private Logger logger;
    private final LazyValue<Integer> loaded = new LazyValue(this::initLoaded);
    private final LazyValue<Map<MavenProject, ProjectStateStatus>> states = new LazyValue(this::initStates);

    public int loaded() {
        return (Integer)this.loaded.get();
    }

    public Map<MavenProject, ProjectStateStatus> states() {
        return (Map)this.states.get();
    }

    private int initLoaded() {
        long count = this.states().values().stream().filter(s -> s.code() == 0).count();
        return Math.toIntExact(count);
    }

    private Map<MavenProject, ProjectStateStatus> initStates() {
        if (this.session.getGoals().contains("clean")) {
            return Map.of();
        }
        ProjectDependencyGraph pdg = this.session.getProjectDependencyGraph();
        HashMap<MavenProject, ProjectStateStatus> statusMap = new HashMap<MavenProject, ProjectStateStatus>();
        ArrayDeque<MavenProject> stack = new ArrayDeque<MavenProject>(this.session.getProjects());
        block0: while (!stack.isEmpty()) {
            MavenProject project = (MavenProject)stack.pop();
            ProjectStateStatus stateStatus = statusMap.computeIfAbsent(project, this::processState);
            if (stateStatus.code() != 0) continue;
            for (MavenProject upstream : pdg.getUpstreamProjects(project, true)) {
                ProjectStateStatus uss = statusMap.computeIfAbsent(upstream, this::processState);
                if (uss.code() == 0) continue;
                statusMap.put(project, stateStatus.invalidate());
                for (MavenProject downstream : pdg.getDownstreamProjects(project, true)) {
                    if (stack.contains(downstream)) continue;
                    stack.addLast(downstream);
                }
                continue block0;
            }
        }
        return statusMap;
    }

    public void save(MavenProject project) {
        CacheConfig cacheConfig = this.configManager.cacheConfig();
        if (cacheConfig.record()) {
            try {
                ProjectState projectState = null;
                ProjectFiles projectFiles = null;
                ProjectStateStatus stateStatus = this.states().get(project);
                if (stateStatus != null && stateStatus.code() != 1) {
                    projectFiles = stateStatus.projectFiles();
                    projectState = stateStatus.state();
                }
                List<ExecutionEntry> newExecutions = this.executionManager.recordedExecutions(project);
                ProjectState.merge(projectState, project, this.session, this.configManager, newExecutions, projectFiles).save(project, cacheConfig.recordSuffix().map(suffix -> "state-" + suffix + ".xml").orElse("state.xml"));
            }
            catch (IOException | UncheckedIOException ex) {
                this.logger.error("Error while saving project state", (Throwable)ex);
            }
        }
    }

    private ProjectStateStatus processState(MavenProject project) {
        ProjectFiles projectFiles;
        CacheConfig cacheConfig = this.configManager.cacheConfig();
        if (!cacheConfig.enabled()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("[%s:%s] - cache is disabled, not loading state", project.getGroupId(), project.getArtifactId()));
            }
            return ProjectStateStatus.UNAVAILABLE;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("[%s:%s] - loading state", project.getGroupId(), project.getArtifactId()));
        }
        List<String> suffixes = cacheConfig.loadSuffixes();
        ArrayList<String> stateFileNames = new ArrayList<String>(Lists.map(suffixes, suffix -> "state-" + suffix + ".xml"));
        stateFileNames.add("state.xml");
        ProjectState state = null;
        try {
            for (String stateFileName : stateFileNames) {
                ProjectState nextState = ProjectState.load(project, stateFileName);
                if (nextState == null) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug(String.format("[%s:%s] - state file not found: %s", project.getGroupId(), project.getArtifactId(), stateFileName));
                    continue;
                }
                if (state == null) {
                    state = nextState;
                    continue;
                }
                state = ProjectState.merge(state, nextState);
            }
            if (state == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(String.format("[%s:%s] - state file(s) not found", project.getGroupId(), project.getArtifactId()));
                }
                return ProjectStateStatus.UNAVAILABLE;
            }
        }
        catch (XMLException | IOException ex) {
            this.logger.error("Error while loading project state for " + project, ex);
            return ProjectStateStatus.UNAVAILABLE;
        }
        try {
            projectFiles = ProjectFiles.of(project, this.configManager);
        }
        catch (IOException ex) {
            this.logger.error("Error while checking project files for " + project, (Throwable)ex);
            return ProjectStateStatus.UNAVAILABLE;
        }
        if (!state.projectFiles().equals(projectFiles)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("[%s:%s] - files changed - state is invalid", project.getGroupId(), project.getArtifactId()));
            }
            return new ProjectStateStatus(2, state, projectFiles);
        }
        return new ProjectStateStatus(0, state, projectFiles);
    }
}

