/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.common.Lists;
import io.helidon.build.common.SourcePath;
import io.helidon.build.common.Strings;
import io.helidon.build.common.xml.XMLElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public final class CacheConfig {
    private static final Properties EMPTY_PROPS = new Properties();
    static final CacheConfig EMPTY = new CacheConfig(null, EMPTY_PROPS, EMPTY_PROPS);
    private final boolean enabled;
    private final boolean record;
    private final String reactorRule;
    private final String moduleSet;
    private final boolean enableChecksums;
    private final boolean includeAllChecksums;
    private final List<LifecycleConfig> lifecyleConfig = new ArrayList<LifecycleConfig>();
    private final List<ReactorRule> reactorRules = new ArrayList<ReactorRule>();

    CacheConfig(XMLElement xmlElt, Properties sysProps, Properties userProps) {
        boolean enableChecksums = false;
        boolean includeAllChecksums = false;
        String enabledValue = CacheConfig.stringProperty(sysProps, userProps, "cache.enabled");
        boolean enabled = CacheConfig.parseBoolean(enabledValue, false);
        String recordValue = CacheConfig.stringProperty(sysProps, userProps, "cache.record");
        boolean record = CacheConfig.parseBoolean(enabledValue, true);
        if (xmlElt != null) {
            XMLElement lifecycleConfigElt;
            if (enabledValue == null) {
                enabled = CacheConfig.booleanElement(xmlElt, "enabled", false);
            }
            if (recordValue == null) {
                record = CacheConfig.booleanElement(xmlElt, "record", true);
            }
            if ((lifecycleConfigElt = (XMLElement)xmlElt.child("lifecycleConfig").orElse(null)) != null) {
                enableChecksums = CacheConfig.booleanElement(lifecycleConfigElt, "enableChecksums", false);
                includeAllChecksums = CacheConfig.booleanElement(lifecycleConfigElt, "includeAllChecksums", false);
                for (XMLElement projectElt : lifecycleConfigElt.children("project")) {
                    String path = projectElt.attribute("path", null);
                    String glob = projectElt.attribute("glob", null);
                    String regex = projectElt.attribute("regex", null);
                    boolean projectEnabled = CacheConfig.booleanElement(projectElt, "enabled", true);
                    List<String> executionsIncludes = CacheConfig.stringListElement(projectElt, "executionsIncludes");
                    List<String> executionsExcludes = CacheConfig.stringListElement(projectElt, "executionsExcludes");
                    List<String> projectFilesExcludes = CacheConfig.stringListElement(projectElt, "projectFilesExcludes");
                    this.lifecyleConfig.add(new LifecycleConfig(path, glob, regex, projectEnabled, executionsIncludes, executionsExcludes, projectFilesExcludes));
                }
            }
            this.reactorRules.addAll(Lists.map((Collection)xmlElt.childrenAt(new String[]{"reactorRules", "reactorRule"}), r -> {
                String name = r.attribute("name");
                List<String> profiles = CacheConfig.stringListElement(r, "profiles");
                List moduleSets = Lists.map((Collection)r.childrenAt(new String[]{"moduleSets", "moduleSet"}), m -> {
                    String moduleSetName = m.attribute("name");
                    List<String> includes = CacheConfig.stringListElement(m, "includes");
                    List<String> excludes = CacheConfig.stringListElement(m, "excludes");
                    return new ModuleSet(moduleSetName, includes, excludes);
                });
                return new ReactorRule(name, profiles, moduleSets);
            }));
        }
        this.enableChecksums = enableChecksums;
        this.includeAllChecksums = includeAllChecksums;
        this.enabled = enabled;
        this.record = record;
        this.reactorRule = CacheConfig.stringProperty(sysProps, userProps, "reactorRule");
        this.moduleSet = CacheConfig.stringProperty(sysProps, userProps, "moduleSet");
    }

    boolean enableChecksums() {
        return this.enableChecksums;
    }

    boolean includeAllChecksums() {
        return this.includeAllChecksums;
    }

    boolean enabled() {
        return this.enabled;
    }

    public boolean record() {
        return this.record;
    }

    public String reactorRule() {
        return this.reactorRule;
    }

    public String moduleSet() {
        return this.moduleSet;
    }

    List<LifecycleConfig> lifecyleConfig() {
        return this.lifecyleConfig;
    }

    List<ReactorRule> reactorRules() {
        return this.reactorRules;
    }

    private static List<String> stringListElement(XMLElement xmlElt, String eltName) {
        return xmlElt.child(eltName).map(e -> Lists.map((Collection)e.children(), XMLElement::value)).map(l -> Lists.filter((Collection)l, Strings::isValid)).orElse(List.of());
    }

    private static boolean booleanElement(XMLElement xmlElt, String eltName, boolean defaultValue) {
        return xmlElt.child(eltName).map(e -> CacheConfig.parseBoolean(e.value(), defaultValue)).orElse(defaultValue);
    }

    private static boolean parseBoolean(String str, boolean defaultValue) {
        return str == null || str.isEmpty() ? defaultValue : Boolean.parseBoolean(str);
    }

    private static String stringProperty(Properties sysProps, Properties userProps, String prop) {
        String value = sysProps.getProperty(prop);
        return value != null ? value : userProps.getProperty(prop);
    }

    public static final class LifecycleConfig {
        static final LifecycleConfig EMPTY = new LifecycleConfig(null, null, null, true, List.of(), List.of(), List.of());
        private final String path;
        private final String glob;
        private final String regex;
        private final boolean enabled;
        private final List<String> executionsIncludes;
        private final List<String> executionsExcludes;
        private final List<String> projectFilesExcludes;

        public LifecycleConfig(String path, String glob, String regex, boolean enabled, List<String> executionsIncludes, List<String> executionsExcludes, List<String> projectFilesExcludes) {
            this.path = path;
            this.glob = glob;
            this.regex = regex;
            this.enabled = enabled;
            this.executionsIncludes = executionsIncludes;
            this.executionsExcludes = executionsExcludes;
            this.projectFilesExcludes = projectFilesExcludes;
        }

        boolean matches(String project) {
            return project.equals(this.path) || this.glob != null && SourcePath.wildcardMatch((String)("/" + project), (String)this.glob) || this.regex != null && project.matches(this.regex);
        }

        public String path() {
            return this.path;
        }

        public String glob() {
            return this.glob;
        }

        public String regex() {
            return this.regex;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public List<String> executionsIncludes() {
            return this.executionsIncludes;
        }

        public List<String> executionsExcludes() {
            return this.executionsExcludes;
        }

        public List<String> projectFilesExcludes() {
            return this.projectFilesExcludes;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            LifecycleConfig that = (LifecycleConfig)obj;
            return Objects.equals(this.path, that.path) && Objects.equals(this.glob, that.glob) && Objects.equals(this.regex, that.regex) && Objects.equals(this.executionsIncludes, that.executionsIncludes) && Objects.equals(this.executionsExcludes, that.executionsExcludes) && Objects.equals(this.projectFilesExcludes, that.projectFilesExcludes);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.glob, this.regex, this.executionsIncludes, this.executionsExcludes, this.projectFilesExcludes);
        }

        public String toString() {
            return "LifecycleConfig[path=" + this.path + ", glob=" + this.glob + ", regex=" + this.regex + ", executionsIncludes=" + this.executionsIncludes + ", executionsExcludes=" + this.executionsExcludes + ", projectFilesExcludes=" + this.projectFilesExcludes + "]";
        }
    }

    public static final class ReactorRule {
        private final String name;
        private final List<String> profiles;
        private final List<ModuleSet> moduleSets;

        public ReactorRule(String name, List<String> profiles, List<ModuleSet> moduleSets) {
            this.name = name;
            this.profiles = profiles;
            this.moduleSets = moduleSets;
        }

        public String name() {
            return this.name;
        }

        public List<String> profiles() {
            return this.profiles;
        }

        public List<ModuleSet> moduleSets() {
            return this.moduleSets;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ReactorRule that = (ReactorRule)obj;
            return Objects.equals(this.name, that.name) && Objects.equals(this.profiles, that.profiles) && Objects.equals(this.moduleSets, that.moduleSets);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.profiles, this.moduleSets);
        }

        public String toString() {
            return "ReactorRule[name=" + this.name + ", profiles=" + this.profiles + ", moduleSets=" + this.moduleSets + "]";
        }
    }

    public static final class ModuleSet {
        private final String name;
        private final List<String> includes;
        private final List<String> excludes;

        public ModuleSet(String name, List<String> includes, List<String> excludes) {
            this.name = name;
            this.includes = includes;
            this.excludes = excludes;
        }

        public String name() {
            return this.name;
        }

        public List<String> includes() {
            return this.includes;
        }

        public List<String> excludes() {
            return this.excludes;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ModuleSet that = (ModuleSet)obj;
            return Objects.equals(this.name, that.name) && Objects.equals(this.includes, that.includes) && Objects.equals(this.excludes, that.excludes);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.includes, this.excludes);
        }

        public String toString() {
            return "ModuleSet[name=" + this.name + ", includes=" + this.includes + ", excludes=" + this.excludes + "]";
        }
    }
}

