/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.common.Strings;
import io.helidon.build.common.xml.XMLElement;
import io.helidon.build.maven.cache.CacheConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.SessionScoped;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;

@Named
@SessionScoped
public class CacheConfigManager {
    private final MavenSession session;
    private final CacheConfig cacheConfig;
    private final CacheConfig.ReactorRule reactorRule;
    private final Map<MavenProject, CacheConfig.LifecycleConfig> lifecycleConfigCache = new ConcurrentHashMap<MavenProject, CacheConfig.LifecycleConfig>();

    @Inject
    public CacheConfigManager(MavenSession session) {
        this.session = session;
        this.cacheConfig = this.initCacheConfig();
        this.reactorRule = this.initReactorRule();
    }

    public CacheConfig cacheConfig() {
        return this.cacheConfig;
    }

    public CacheConfig.LifecycleConfig lifecycleConfig(MavenProject project) {
        return this.lifecycleConfigCache.computeIfAbsent(project, p -> {
            String projectPath = Strings.normalizePath((Object)this.root().relativize(p.getFile().toPath().toAbsolutePath()));
            return this.cacheConfig().lifecyleConfig().stream().filter(c -> c.matches(projectPath)).findFirst().orElse(CacheConfig.LifecycleConfig.EMPTY);
        });
    }

    public CacheConfig.ReactorRule reactorRule() {
        return this.reactorRule;
    }

    private CacheConfig initCacheConfig() {
        try {
            Path configFile = this.root().resolve(".mvn/cache-config.xml");
            if (Files.exists(configFile, new LinkOption[0])) {
                XMLElement elt = XMLElement.parse((InputStream)Files.newInputStream(configFile, new OpenOption[0]));
                return new CacheConfig(elt, this.session.getSystemProperties(), this.session.getUserProperties());
            }
            return CacheConfig.EMPTY;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private CacheConfig.ReactorRule initReactorRule() {
        String name = this.cacheConfig.reactorRule();
        if (name == null || name.isEmpty()) {
            return null;
        }
        return this.cacheConfig.reactorRules().stream().filter(r -> r.name().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("ReactorRule not found: " + name));
    }

    private Path root() {
        return this.session.getRequest().getMultiModuleProjectDirectory().toPath();
    }
}

