/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.common.Diff;
import io.helidon.build.common.xml.XMLElement;
import io.helidon.build.maven.cache.ConfigHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ConfigDiff {
    private ConfigDiff() {
    }

    public abstract String asString();

    static List<ConfigDiff> diff(XMLElement orig, XMLElement actual) {
        return ConfigDiff.diff("", orig, actual);
    }

    private static List<ConfigDiff> diff(String path, XMLElement orig, XMLElement actual) {
        String actualValue;
        ArrayList<ConfigDiff> configDiffs = new ArrayList<ConfigDiff>();
        String origValue = orig.value();
        if (!origValue.equals(actualValue = actual.value())) {
            configDiffs.add(new Update(path, origValue, actualValue));
        }
        Map origAttrs = orig.attributes();
        Map actualAttrs = actual.attributes();
        origAttrs.forEach((attrName, origAttrValue) -> {
            String actualAttrValue = (String)actualAttrs.get(attrName);
            String attrPath = (String)(path.isEmpty() ? "" : path + "/") + "@" + attrName;
            if (actualAttrValue == null) {
                configDiffs.add(new Remove(attrPath));
            } else if (!origAttrValue.equals(actualAttrValue)) {
                configDiffs.add(new Update(attrPath, origAttrValue, actualAttrValue));
            }
        });
        actualAttrs.forEach((attrName, actualAttrValue) -> {
            String attrPath = (String)(path.isEmpty() ? "" : path + "/") + "@" + attrName;
            if (!origAttrs.containsKey(attrName)) {
                configDiffs.add(new Add(attrPath));
            }
        });
        List rawDiffs = Diff.diff((List)orig.children(), (List)actual.children());
        HashMap<String, List> diffsByPath = new HashMap<String, List>();
        for (Diff diff : rawDiffs) {
            String origPath;
            String p2;
            if (diff.isAdd()) {
                p2 = ConfigHelper.subpath(actual, (XMLElement)diff.element());
                diffsByPath.computeIfAbsent(p2, k -> new ArrayList()).add(diff);
                continue;
            }
            if (diff.isRemove()) {
                p2 = ConfigHelper.subpath(orig, (XMLElement)diff.element());
                diffsByPath.computeIfAbsent(p2, k -> new ArrayList()).add(diff);
                continue;
            }
            String actualPath = ConfigHelper.subpath(actual, (XMLElement)diff.element());
            if (actualPath.equals(origPath = ConfigHelper.subpath(orig, (XMLElement)diff.element()))) continue;
            configDiffs.add(new Move(origPath, actualPath));
        }
        diffsByPath.forEach((p, diffs) -> {
            if (diffs.size() == 1) {
                Diff diff = (Diff)diffs.get(0);
                if (diff.isAdd()) {
                    configDiffs.add(new Add((String)p));
                    return;
                }
                if (diff.isRemove()) {
                    configDiffs.add(new Remove((String)p));
                    return;
                }
            } else if (diffs.size() == 2) {
                Diff diff1 = (Diff)diffs.get(0);
                Diff diff2 = (Diff)diffs.get(1);
                if (diff1.isAdd() && diff2.isRemove() || diff1.isRemove() && diff2.isAdd()) {
                    XMLElement origElt = diff1.isRemove() ? (XMLElement)diff1.element() : (XMLElement)diff2.element();
                    XMLElement actualElt = diff1.isAdd() ? (XMLElement)diff1.element() : (XMLElement)diff2.element();
                    configDiffs.addAll(ConfigDiff.diff(p, origElt, actualElt));
                    return;
                }
            }
            throw new IllegalStateException(String.format("Invalid diffs for path: %s - %s", p, diffs));
        });
        return configDiffs;
    }

    static class Update
    extends ConfigDiff {
        private final String path;
        private final String origValue;
        private final String actualValue;

        Update(String path, Object origValue, Object actualValue) {
            this.path = path;
            this.origValue = origValue.toString();
            this.actualValue = actualValue.toString();
        }

        String orig() {
            return this.origValue;
        }

        String actual() {
            return this.actualValue;
        }

        @Override
        public String asString() {
            return this.path + " was '" + this.origValue + "' but is now '" + this.actualValue + "'";
        }
    }

    static class Move
    extends ConfigDiff {
        private final String origPath;
        private final String actualPath;

        Move(String origPath, String actualPath) {
            this.origPath = origPath;
            this.actualPath = actualPath;
        }

        @Override
        public String asString() {
            return this.origPath + " has been moved to " + this.actualPath;
        }
    }

    static class Add
    extends ConfigDiff {
        private final String path;

        Add(String path) {
            this.path = path;
        }

        @Override
        public String asString() {
            return this.path + " has been added";
        }
    }

    static class Remove
    extends ConfigDiff {
        private final String path;

        Remove(String path) {
            this.path = path;
        }

        @Override
        public String asString() {
            return this.path + " has been removed";
        }
    }
}

