/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.common.xml.XMLElement;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.xml.Xpp3Dom;

class ConfigHelper {
    private ConfigHelper() {
    }

    static String path(XMLElement elt) {
        return ConfigHelper.subpath(null, elt);
    }

    static String subpath(XMLElement begin, XMLElement end) {
        StringBuilder sb = new StringBuilder();
        for (XMLElement e = end; e != null && e != begin; e = e.parent()) {
            Object segment = e.name();
            int index = ConfigHelper.index(e);
            if (index >= 0) {
                segment = (String)segment + "[" + index + "]";
            }
            if (e != end) {
                segment = (String)segment + "/";
            }
            sb.insert(0, (String)segment);
        }
        return sb.toString();
    }

    static int index(XMLElement elt) {
        List elements;
        int count = 0;
        if (elt.parent() != null && (elements = elt.parent().children(elt.name())).size() > 1) {
            for (XMLElement e : elements) {
                if (e == elt) {
                    return count;
                }
                ++count;
            }
        }
        return -1;
    }

    static XMLElement toXMLElement(Xpp3Dom elt) {
        Xpp3Converter converter = new Xpp3Converter();
        ArrayDeque<Xpp3Dom> stack = new ArrayDeque<Xpp3Dom>();
        stack.push(elt);
        Xpp3Dom parent = elt.getParent();
        while (!stack.isEmpty()) {
            Xpp3Dom e = (Xpp3Dom)stack.peek();
            if (parent == e) {
                parent = e.getParent();
                stack.pop();
                converter.postVisitElement();
                continue;
            }
            converter.visitElement(e);
            parent = e;
            Xpp3Dom[] children = e.getChildren();
            for (int i = children.length - 1; i >= 0; --i) {
                stack.push(children[i]);
            }
        }
        return converter.stack.pop().build();
    }

    private static final class Xpp3Converter {
        private final Deque<XMLElement.Builder> stack = new ArrayDeque<XMLElement.Builder>();

        private Xpp3Converter() {
        }

        void visitElement(Xpp3Dom elt) {
            XMLElement.Builder builder = XMLElement.builder().modifiable(true).name(elt.getName()).attributes(Xpp3Converter.attributes(elt)).value(elt.getValue());
            if (!this.stack.isEmpty()) {
                this.stack.peek().child(builder);
            }
            this.stack.push(builder);
        }

        void postVisitElement() {
            if (this.stack.size() > 1) {
                this.stack.pop();
            }
        }

        static Map<String, String> attributes(Xpp3Dom elt) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (String attrName : elt.getAttributeNames()) {
                attributes.put(attrName, elt.getAttribute(attrName));
            }
            return attributes;
        }
    }
}

