/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.maven.cache.ConfigDiff;
import io.helidon.build.maven.cache.ProjectFiles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class ProjectFilesDiffs
implements Iterable<ConfigDiff> {
    private final List<ConfigDiff> diffs = new ArrayList<ConfigDiff>();

    ProjectFilesDiffs(ProjectFiles orig, ProjectFiles actual) {
        if (actual != null) {
            if (orig.filesCount() != actual.filesCount()) {
                this.diffs.add(new ConfigDiff.Update("count", orig.filesCount(), actual.filesCount()));
            }
            if (orig.lastModified() != actual.lastModified()) {
                this.diffs.add(new ConfigDiff.Update("last-modified", orig.lastModified(), actual.lastModified()));
            }
            if (!Objects.equals(orig.checksum(), actual.checksum())) {
                this.diffs.add(new ConfigDiff.Update("checksum", orig.checksum(), actual.checksum()));
            }
            Map<String, String> ocs = orig.allChecksums();
            Map<String, String> acs = actual.allChecksums();
            ocs.entrySet().stream().filter(e -> !((String)e.getValue()).equals(acs.get(e.getKey()))).forEach(e -> {
                if (acs.containsKey(e.getKey())) {
                    this.diffs.add(new ConfigDiff.Update((String)e.getKey(), e.getValue(), acs.get(e.getKey())));
                } else {
                    this.diffs.add(new ConfigDiff.Remove((String)e.getKey()));
                }
            });
            acs.entrySet().stream().filter(e -> !ocs.containsKey(e.getKey())).forEach(e -> this.diffs.add(new ConfigDiff.Add((String)e.getKey())));
        }
    }

    @Override
    public Iterator<ConfigDiff> iterator() {
        return this.diffs.iterator();
    }
}

