/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cache;

import io.helidon.build.common.Lists;
import io.helidon.build.common.Strings;
import io.helidon.build.common.xml.XMLElement;
import io.helidon.build.common.xml.XMLException;
import io.helidon.build.common.xml.XMLWriter;
import io.helidon.build.maven.cache.ArtifactEntry;
import io.helidon.build.maven.cache.CacheConfigManager;
import io.helidon.build.maven.cache.ExecutionEntry;
import io.helidon.build.maven.cache.ProjectFiles;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.project.DefaultMavenProjectHelper;
import org.apache.maven.project.MavenProject;

final class ProjectState {
    private static final String STATE_FILE_NAME = "state.xml";
    private static final DefaultMavenProjectHelper PROJECT_HELPER = new DefaultMavenProjectHelper();
    private final Properties properties;
    private final ArtifactEntry artifact;
    private final List<ArtifactEntry> attachedArtifacts;
    private final List<String> compileSourceRoots;
    private final List<String> testCompileSourceRoots;
    private final ProjectFiles projectFiles;
    private final List<ExecutionEntry> executions;
    private final Map<ExecutionEntry, Optional<ExecutionEntry>> executionMatches;

    ProjectState(Properties properties, ArtifactEntry artifact, List<ArtifactEntry> attachedArtifacts, List<String> compileSourceRoots, List<String> testCompileSourceRoots, ProjectFiles projectFiles, List<ExecutionEntry> executions) {
        this.properties = Objects.requireNonNull(properties, "properties is null");
        this.artifact = artifact;
        this.attachedArtifacts = attachedArtifacts == null ? List.of() : attachedArtifacts;
        this.compileSourceRoots = compileSourceRoots == null ? List.of() : compileSourceRoots;
        this.testCompileSourceRoots = testCompileSourceRoots == null ? List.of() : testCompileSourceRoots;
        this.projectFiles = Objects.requireNonNull(projectFiles, "projectFiles is null");
        this.executions = executions == null ? List.of() : executions;
        this.executionMatches = new HashMap<ExecutionEntry, Optional<ExecutionEntry>>();
    }

    Properties properties() {
        return this.properties;
    }

    ArtifactEntry artifact() {
        return this.artifact;
    }

    List<ArtifactEntry> attachedArtifacts() {
        return this.attachedArtifacts;
    }

    List<String> compileSourceRoots() {
        return this.compileSourceRoots;
    }

    List<String> testCompileSourceRoots() {
        return this.testCompileSourceRoots;
    }

    ProjectFiles projectFiles() {
        return this.projectFiles;
    }

    List<ExecutionEntry> executions() {
        return this.executions;
    }

    static ProjectState load(MavenProject project) throws IOException, XMLException {
        return ProjectState.load(project.getModel().getProjectDirectory().toPath().resolve(project.getModel().getBuild().getDirectory()).resolve(STATE_FILE_NAME));
    }

    static ProjectState load(Path stateFile) throws IOException, XMLException {
        if (!Files.exists(stateFile, new LinkOption[0])) {
            return null;
        }
        Properties properties = new Properties();
        XMLElement rootElt = XMLElement.parse((InputStream)Files.newInputStream(stateFile, new OpenOption[0]));
        for (XMLElement elt : rootElt.childrenAt(new String[]{"properties", "property"})) {
            String name = elt.attribute("name", null);
            String value = elt.attribute("value", null);
            if (name == null || name.isEmpty() || value == null) continue;
            properties.setProperty(name, value);
        }
        ArtifactEntry artifact = rootElt.child("artifact").map(ProjectState::readArtifact).orElse(null);
        List attachedArtifacts = Lists.map((Collection)rootElt.childrenAt(new String[]{"attached-artifacts", "artifact"}), ProjectState::readArtifact);
        List<String> compileSourceRoots = rootElt.childrenAt(new String[]{"compile-source-roots", "path"}).stream().map(XMLElement::value).filter(Strings::isValid).collect(Collectors.toList());
        List<String> testCompileSourceRoots = rootElt.childrenAt(new String[]{"test-compile-source-roots", "path"}).stream().map(XMLElement::value).filter(Strings::isValid).collect(Collectors.toList());
        ProjectFiles projectFiles = ProjectFiles.fromXml(rootElt.child("project-files").orElse(null));
        List executions = Lists.map((Collection)rootElt.childrenAt(new String[]{"executions", "execution"}), e -> {
            Map attributes = e.attributes();
            return new ExecutionEntry((String)attributes.get("groupId"), (String)attributes.get("artifactId"), (String)attributes.get("version"), (String)attributes.get("goal"), (String)attributes.get("id"), e.child("configuration").map(XMLElement::detach).orElseGet(() -> XMLElement.builder().build()));
        });
        return new ProjectState(properties, artifact, attachedArtifacts, compileSourceRoots, testCompileSourceRoots, projectFiles, executions);
    }

    void save(MavenProject project) throws IOException {
        Model model = project.getModel();
        Path buildDir = model.getProjectDirectory().toPath().resolve(model.getBuild().getDirectory());
        if (!Files.exists(buildDir, new LinkOption[0])) {
            Files.createDirectories(buildDir, new FileAttribute[0]);
        }
        this.save(buildDir.resolve(STATE_FILE_NAME));
    }

    void save(Path stateFile) throws IOException {
        XMLWriter writer = new XMLWriter((Writer)Files.newBufferedWriter(stateFile, new OpenOption[0]));
        writer.prolog().startElement("project-state");
        writer.startElement("properties");
        this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> writer.startElement("property").attribute("name", k.toString()).attribute("value", v.toString()).endElement()));
        writer.endElement();
        if (this.artifact != null) {
            ProjectState.writeArtifact(writer, this.artifact);
        }
        writer.startElement("attached-artifacts");
        for (ArtifactEntry artifact : this.attachedArtifacts) {
            ProjectState.writeArtifact(writer, artifact);
        }
        writer.endElement();
        writer.startElement("compile-source-roots");
        for (String path : this.compileSourceRoots) {
            writer.startElement("path").value(path).endElement();
        }
        writer.endElement();
        writer.startElement("test-compile-source-roots");
        for (String path : this.testCompileSourceRoots) {
            writer.startElement("path").value(path).endElement();
        }
        writer.endElement();
        writer.startElement("project-files");
        writer.attribute("count", (Object)this.projectFiles.filesCount());
        writer.attribute("last-modified", (Object)this.projectFiles.lastModified());
        String checksum = this.projectFiles.checksum();
        if (checksum != null) {
            writer.attribute("checksum", checksum);
        }
        this.projectFiles.allChecksums().forEach((k, v) -> writer.startElement("file").attribute("checksum", v).value(k).endElement());
        writer.endElement();
        writer.startElement("executions");
        for (ExecutionEntry execution : this.executions) {
            writer.startElement("execution").attribute("groupId", execution.groupId()).attribute("artifactId", execution.artifactId()).attribute("version", execution.version()).attribute("goal", execution.goal()).attribute("id", execution.executionId());
            writer.append(execution.config());
            writer.endElement();
        }
        writer.endElement();
        writer.endElement();
        writer.close();
    }

    private static ArtifactEntry readArtifact(XMLElement elt) {
        Map attributes = elt.attributes();
        return new ArtifactEntry((String)attributes.get("file"), (String)attributes.get("extension"), (String)attributes.get("classifier"), (String)attributes.get("language"), Boolean.parseBoolean((String)attributes.get("includesDependencies")), Boolean.parseBoolean((String)attributes.get("addedToClasspath")));
    }

    private static void writeArtifact(XMLWriter writer, ArtifactEntry artifact) {
        String language;
        String classifier;
        writer.startElement("artifact").attribute("file", artifact.file());
        String extension = artifact.extension();
        if (extension != null && !extension.isEmpty()) {
            writer.attribute("extension", extension);
        }
        if ((classifier = artifact.classifier()) != null && !classifier.isEmpty()) {
            writer.attribute("classifier", classifier);
        }
        if ((language = artifact.language()) != null && !language.isEmpty()) {
            writer.attribute("language", language);
        }
        writer.attribute("includesDependencies", (Object)artifact.includesDependencies());
        writer.attribute("addedToClasspath", (Object)artifact.addedToClasspath());
        writer.endElement();
    }

    void apply(MavenProject project, MavenSession session) {
        Path projectDir = project.getModel().getProjectDirectory().toPath();
        this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> project.getProperties().put(k, ProjectState.loadPropValue(session, (String)v))));
        Optional.ofNullable(this.artifact).map(a -> a.toArtifact(project)).ifPresent(arg_0 -> ((MavenProject)project).setArtifact(arg_0));
        this.compileSourceRoots.stream().map(projectDir::resolve).map(Object::toString).filter(Predicate.not(project.getCompileSourceRoots()::contains)).forEach(arg_0 -> ((MavenProject)project).addCompileSourceRoot(arg_0));
        this.testCompileSourceRoots.stream().map(projectDir::resolve).map(Object::toString).filter(Predicate.not(project.getTestCompileSourceRoots()::contains)).forEach(arg_0 -> ((MavenProject)project).addTestCompileSourceRoot(arg_0));
        this.attachedArtifacts.stream().map(a -> a.toArtifact(project)).forEach(a -> PROJECT_HELPER.attachArtifact(project, a));
    }

    boolean hasMatchingExecution(ExecutionEntry execution) {
        return this.findMatchingExecution(execution) != null;
    }

    ExecutionEntry findMatchingExecution(ExecutionEntry execution) {
        return this.executionMatches.computeIfAbsent(execution, key -> {
            for (ExecutionEntry exec : this.executions) {
                if (!exec.matches((ExecutionEntry)key)) continue;
                return Optional.of(exec);
            }
            return Optional.empty();
        }).orElse(null);
    }

    static ProjectState merge(ProjectState state, MavenProject project, MavenSession session, CacheConfigManager configManager, List<ExecutionEntry> newExecutions, ProjectFiles newProjectFiles) throws IOException {
        Properties properties;
        List<Object> executions;
        Path projectDir = project.getModel().getProjectDirectory().toPath();
        if (state == null) {
            executions = List.of();
            properties = new Properties();
        } else {
            executions = state.executions;
            properties = state.properties;
        }
        Properties projectProps = new Properties();
        project.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> projectProps.put(k, ProjectState.savePropValue(session, (String)v))));
        return new ProjectState(ProjectState.mergeProperties(properties, projectProps), Optional.ofNullable(project.getArtifact()).map(a -> ArtifactEntry.create(a, project)).orElse(null), project.getAttachedArtifacts().stream().map(a -> ArtifactEntry.create(a, project)).collect(Collectors.toList()), project.getCompileSourceRoots().stream().map(x$0 -> Paths.get(x$0, new String[0])).map(projectDir::relativize).map(Path::toString).collect(Collectors.toList()), project.getTestCompileSourceRoots().stream().map(x$0 -> Paths.get(x$0, new String[0])).map(projectDir::relativize).map(Path::toString).collect(Collectors.toList()), newProjectFiles == null ? ProjectFiles.of(project, configManager) : newProjectFiles, Stream.concat(executions.stream().filter(exec -> newExecutions.stream().noneMatch(exec::matches)), newExecutions.stream()).collect(Collectors.toList()));
    }

    private static String loadPropValue(MavenSession session, String value) {
        String rootDir = session.getRequest().getMultiModuleProjectDirectory().toPath().toString();
        return value.replace("#{root.dir}", rootDir);
    }

    private static String savePropValue(MavenSession session, String value) {
        String rootDir = session.getRequest().getMultiModuleProjectDirectory().toPath().toString();
        return value.replace(rootDir, "#{root.dir}");
    }

    private static Properties mergeProperties(Properties props1, Properties props2) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)props1);
        properties.putAll((Map<?, ?>)props2);
        return properties;
    }
}

