/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.cache.plugin;

import io.helidon.build.common.Lists;
import io.helidon.build.common.Strings;
import io.helidon.build.common.logging.Log;
import io.helidon.build.common.logging.LogLevel;
import io.helidon.build.common.maven.MavenModel;
import io.helidon.build.common.maven.plugin.MavenArtifact;
import io.helidon.build.common.maven.plugin.MavenFilters;
import io.helidon.build.common.maven.plugin.PlexusLoggerHolder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

@Mojo(name="go-offline", threadSafe=true, requiresDirectInvocation=true, aggregator=true)
public class GoOfflineMojo
extends AbstractMojo {
    @Component
    private PlexusLoggerHolder plexusLogHolder;
    @Component
    private RepositorySystem repoSystem;
    @Component
    private ProjectBuilder projectBuilder;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(property="cache.offline.pomScanningIdentity", defaultValue="pom.xml")
    private List<String> pomScanningIdentity = List.of();
    @Parameter(property="cache.offline.pomScanningIncludes", defaultValue="**/*")
    private List<String> pomScanningIncludes = List.of();
    @Parameter(property="cache.offline.pomScanningExcludes", defaultValue="**/target/**,**/src/**")
    private List<String> pomScanningExcludes = List.of();
    @Parameter(property="cache.offline.pomIncludes", defaultValue="*:*:*")
    private List<String> pomIncludes = List.of();
    @Parameter(property="cache.offline.pomExcludes")
    private List<String> pomExcludes = List.of();
    @Parameter(property="cache.offline.includeSnapshots", defaultValue="false")
    private boolean includeSnapshots;
    @Parameter(property="cache.offline.includeDependencies", defaultValue="true")
    private boolean includeDeps;
    @Parameter(property="cache.offline.includeDependencyManagement", defaultValue="false")
    private boolean includeDepsMgmt;
    @Parameter(property="cache.offline.includePlugins", defaultValue="true")
    private boolean includePlugins;
    @Parameter(property="cache.offline.includePluginManagement", defaultValue="false")
    private boolean includePluginMgmt;
    @Parameter(property="cache.offline.traverse", defaultValue="true")
    private boolean traverse;
    @Parameter(property="cache.offline.profileIncludes", defaultValue="*")
    private List<String> profileIncludes = List.of();
    @Parameter(property="cache.offline.profileExcludes")
    private List<String> profileExcludes = List.of();
    @Parameter(property="cache.offline.scopeIncludes", defaultValue="*")
    private List<String> scopeIncludes = List.of();
    @Parameter(property="cache.offline.scopeExcludes", defaultValue="test")
    private List<String> scopeExcludes = List.of();
    @Parameter(property="cache.offline.includeOptional", defaultValue="true")
    private boolean includeOptional;
    @Parameter(property="cache.offline.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="cache.offline.failOnError", defaultValue="false")
    private boolean failOnError;
    private Predicate<MavenModel> pomFilter;
    private Predicate<Path> pomIdentityFilter;
    private Predicate<Path> pomScanningFilter;
    private Predicate<String> profileFilter;
    private Predicate<String> scopeFilter;
    private Map<MavenArtifact, List<Path>> workspace;
    private final Set<MavenArtifact> resolved = new HashSet<MavenArtifact>();

    public void execute() {
        if (this.skip) {
            Log.info((String)"processing is skipped.", (Object[])new Object[0]);
            return;
        }
        this.pomFilter = MavenFilters.pomFilter(this.pomIncludes, this.pomExcludes);
        this.pomIdentityFilter = MavenFilters.dirFilter(this.pomScanningIdentity);
        this.pomScanningFilter = MavenFilters.pathFilter(this.pomScanningIncludes, this.pomScanningExcludes, (Path)Path.of("", new String[0]));
        this.profileFilter = MavenFilters.stringFilter(this.profileIncludes, this.profileExcludes);
        this.scopeFilter = MavenFilters.stringFilter(this.scopeIncludes, this.scopeExcludes);
        this.workspace = this.scanWorkspace();
        List<MavenProject> allProjects = this.collectProjects();
        List initial = allProjects.stream().map(it -> this.collect((MavenProject)it, false, this.includeDeps, this.includeDepsMgmt, this.includePlugins, this.includePluginMgmt)).flatMap(Collection::stream).distinct().toList();
        this.resolved.addAll(this.workspace.keySet());
        ArrayDeque stack = new ArrayDeque(initial);
        while (!stack.isEmpty()) {
            ResolvableArtifacts e = (ResolvableArtifacts)stack.pop();
            List requests = Lists.filter(e.artifacts, this::filterArtifact);
            if (requests.isEmpty()) continue;
            List<MavenArtifact> result = this.resolve(requests, e.repos);
            this.resolved.addAll(requests);
            if (!this.traverse) continue;
            for (MavenArtifact artifact : result) {
                MavenArtifact pom;
                if (!this.filterArtifact(artifact) || (pom = this.resolve(artifact.pom(), e.repos)) == null) continue;
                Log.debug((String)"Resolving for traversal: %s, requests: %s", (Object[])new Object[]{artifact, requests});
                MavenProject project = this.effectivePom(pom.file());
                if (project == null) continue;
                Log.info((String)"Traversing %s", (Object[])new Object[]{pom});
                List<ResolvableArtifacts> downstream = this.collect(project, true, this.includeDeps, false, false, false);
                downstream.forEach(stack::push);
            }
        }
    }

    private boolean filterArtifact(MavenArtifact artifact) {
        return !this.resolved.contains(artifact) && artifact.version() != null && (this.includeSnapshots || !artifact.version().endsWith("-SNAPSHOT"));
    }

    private boolean filterDependency(Dependency dep, MavenProject project, String profileId) {
        String scope = dep.getScope() == null ? this.scope(project, dep, profileId) : dep.getScope();
        String optional = dep.getOptional() == null ? this.optional(project, dep, profileId) : dep.getOptional();
        return this.scopeFilter.test(scope == null ? "" : scope) && (!Boolean.parseBoolean(optional) || this.includeOptional);
    }

    private List<MavenProject> collectProjects() {
        return this.workspace.values().stream().flatMap(Collection::stream).map(p -> Optional.ofNullable(this.effectivePom((Path)p))).filter(Optional::isPresent).map(Optional::get).toList();
    }

    private Map<MavenArtifact, List<Path>> scanWorkspace() {
        Map<MavenArtifact, List<Path>> map;
        block8: {
            Stream<Path> stream = Files.walk(Path.of("", new String[0]), new FileVisitOption[0]);
            try {
                map = stream.filter(this.pomIdentityFilter).filter(p -> this.pomScanningFilter.test((Path)p)).map(it -> {
                    Path file = it.resolve("pom.xml");
                    Log.debug((String)"Reading model: %s", (Object[])new Object[]{file});
                    return Map.entry(MavenModel.read((Path)file), Lists.of((Object[])new Path[]{file}));
                }).filter(it -> this.pomFilter.test((MavenModel)it.getKey())).collect(Collectors.toMap(it -> new MavenArtifact((MavenModel)it.getKey()), Map.Entry::getValue, Lists::addAll));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            stream.close();
        }
        return map;
    }

    private MavenArtifact resolve(MavenArtifact artifact, Set<RemoteRepository> repositories) {
        try {
            Log.debug((String)"Resolving artifact: %s, repositories: %s", (Object[])new Object[]{artifact, repositories});
            ArtifactRequest request = new ArtifactRequest();
            request.setArtifact(artifact.toAetherArtifact());
            request.setRepositories(new ArrayList<RemoteRepository>(repositories));
            ArtifactResult result = this.repoSystem.resolveArtifact(this.repoSession, request);
            return new MavenArtifact(result.getArtifact());
        }
        catch (ArtifactResolutionException ex) {
            if (this.failOnError) {
                throw new RuntimeException(ex);
            }
            Log.log((LogLevel)LogLevel.DEBUG, (Throwable)ex, (String)"Unable to resolve artifact: %s, repositories: %s", (Object[])new Object[]{artifact, repositories});
            return null;
        }
    }

    private List<MavenArtifact> resolve(List<MavenArtifact> artifacts, Set<RemoteRepository> repositories) {
        try {
            Log.debug((String)"Resolving artifacts: %s, repositories: %s", (Object[])new Object[]{artifacts, repositories});
            ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>(repositories);
            List requests = Lists.map(artifacts, it -> {
                ArtifactRequest request = new ArtifactRequest();
                request.setArtifact(it.toAetherArtifact());
                request.setRepositories(repos);
                return request;
            });
            List results = this.repoSystem.resolveArtifacts(this.repoSession, (Collection)requests);
            return Lists.map((Collection)results, it -> new MavenArtifact(it.getArtifact()));
        }
        catch (ArtifactResolutionException ex) {
            if (this.failOnError) {
                throw new RuntimeException(ex);
            }
            Log.log((LogLevel)LogLevel.DEBUG, (Throwable)ex, (String)"Unable to resolve artifacts: %s, repositories: %s", (Object[])new Object[]{artifacts, repositories});
            return List.of();
        }
    }

    private MavenProject effectivePom(Path pomFile) {
        try {
            Log.debug((String)("resolving effective pom " + pomFile), (Object[])new Object[0]);
            ProjectBuildingRequest orig = this.session.getProjectBuildingRequest();
            DefaultProjectBuildingRequest pbr = new DefaultProjectBuildingRequest(orig);
            pbr.setRemoteRepositories(orig.getRemoteRepositories());
            pbr.setPluginArtifactRepositories(orig.getPluginArtifactRepositories());
            pbr.setProject(null);
            pbr.setValidationLevel(0);
            pbr.setResolveDependencies(false);
            return this.projectBuilder.build(pomFile.toFile(), (ProjectBuildingRequest)pbr).getProject();
        }
        catch (ProjectBuildingException ex) {
            if (this.failOnError) {
                throw new RuntimeException(ex);
            }
            Log.log((LogLevel)LogLevel.DEBUG, (Throwable)ex, (String)"Unable to build effective model for: %s", (Object[])new Object[]{pomFile});
            return null;
        }
    }

    private List<ResolvableArtifacts> collect(MavenProject project, boolean traversing, boolean includeDeps, boolean includeDepsMgmt, boolean includePlugins, boolean includePluginMgmt) {
        ArrayList<ResolvableArtifacts> artifacts = new ArrayList<ResolvableArtifacts>();
        Set<RemoteRepository> repos = this.repos(project.getRepositories(), Set.of());
        Set<RemoteRepository> pluginRepos = this.repos(project.getPluginRepositories(), Set.of());
        if (includeDeps) {
            List deps = project.getDependencies();
            if (traversing) {
                deps = Lists.filter((Collection)deps, it -> this.filterDependency((Dependency)it, project, null));
            }
            artifacts.add(this.collectDeps(project, deps, repos, null));
        }
        if (includeDepsMgmt) {
            artifacts.add(this.collectDepMgmt(project, project.getDependencyManagement(), repos, null));
        }
        if (includePlugins) {
            artifacts.add(this.collectPlugins(project, project.getBuildPlugins(), pluginRepos, null));
        }
        if (includePluginMgmt) {
            artifacts.add(this.collectPluginMgmt(project, project.getPluginManagement(), pluginRepos, null));
        }
        for (MavenProject currentProject = project; currentProject != null; currentProject = currentProject.getParent()) {
            List activeProfileIds = Lists.map((Collection)currentProject.getActiveProfiles(), Profile::getId);
            for (Profile profile : currentProject.getModel().getProfiles()) {
                String profileId = profile.getId();
                if (activeProfileIds.contains(profileId) && this.profileFilter.test(profileId)) continue;
                Set<RemoteRepository> profileRepos = this.repos(profile.getRepositories(), repos);
                Set<RemoteRepository> profilePluginRepos = this.repos(profile.getPluginRepositories(), pluginRepos);
                if (includeDeps) {
                    List deps = profile.getDependencies();
                    if (traversing) {
                        deps = Lists.filter((Collection)deps, it -> this.filterDependency((Dependency)it, project, profileId));
                    }
                    artifacts.add(this.collectDeps(currentProject, deps, profileRepos, profileId));
                }
                if (includeDepsMgmt) {
                    DependencyManagement mgmt = profile.getDependencyManagement();
                    artifacts.add(this.collectDepMgmt(currentProject, mgmt, profileRepos, profileId));
                }
                BuildBase profileBuild = profile.getBuild();
                if (includePlugins) {
                    List plugins = profileBuild != null ? profileBuild.getPlugins() : List.of();
                    artifacts.add(this.collectPlugins(currentProject, plugins, profilePluginRepos, profileId));
                }
                if (!includePluginMgmt) continue;
                PluginManagement mgmt = profileBuild != null ? profileBuild.getPluginManagement() : null;
                artifacts.add(this.collectPluginMgmt(currentProject, mgmt, profilePluginRepos, profileId));
            }
        }
        return Lists.filter(artifacts, it -> !it.artifacts.isEmpty());
    }

    private ResolvableArtifacts collectDeps(MavenProject project, List<Dependency> deps, Set<RemoteRepository> repos, String profileId) {
        ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
        List filtered = Lists.filter(deps, it -> this.filterDependency((Dependency)it, project, profileId));
        filtered.forEach(it -> artifacts.add(new MavenArtifact(it, () -> this.version(project, (Dependency)it, profileId))));
        return new ResolvableArtifacts(artifacts, repos);
    }

    private ResolvableArtifacts collectDepMgmt(MavenProject project, DependencyManagement mgmt, Set<RemoteRepository> repos, String profileId) {
        ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
        if (mgmt != null) {
            mgmt.getDependencies().forEach(it -> artifacts.add(new MavenArtifact(it, () -> this.version(project, (Dependency)it, profileId))));
        }
        return new ResolvableArtifacts(artifacts, repos);
    }

    private ResolvableArtifacts collectPlugins(MavenProject project, List<Plugin> plugins, Set<RemoteRepository> repos, String profileId) {
        ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
        plugins.forEach(it -> artifacts.add(new MavenArtifact(it, () -> this.version(project, (Plugin)it, profileId))));
        return new ResolvableArtifacts(artifacts, repos);
    }

    private ResolvableArtifacts collectPluginMgmt(MavenProject project, PluginManagement mgmt, Set<RemoteRepository> repos, String profileId) {
        ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
        if (mgmt != null) {
            mgmt.getPlugins().forEach(it -> artifacts.add(new MavenArtifact(it, () -> this.version(project, (Plugin)it, profileId))));
        }
        return new ResolvableArtifacts(artifacts, repos);
    }

    private String optional(MavenProject project, Dependency d, String profileId) {
        return this.effectiveValue(project, d, profileId, this::optional, MavenProject::getDependencyManagement, ModelBase::getDependencyManagement);
    }

    private String scope(MavenProject project, Dependency d, String profileId) {
        return this.effectiveValue(project, d, profileId, this::scope, MavenProject::getDependencyManagement, ModelBase::getDependencyManagement);
    }

    private String version(MavenProject project, Dependency d, String profileId) {
        return this.effectiveValue(project, d, profileId, this::version, MavenProject::getDependencyManagement, ModelBase::getDependencyManagement);
    }

    private String version(MavenProject project, Plugin p, String profileId) {
        return this.effectiveValue(project, p, profileId, this::version, MavenProject::getPluginManagement, it -> it.getBuild() != null ? it.getBuild().getPluginManagement() : null);
    }

    private <T, U, R> R effectiveValue(MavenProject project, U u, String profileId, BiFunction<T, U, R> f0, Function<MavenProject, T> f1, Function<Profile, T> f2) {
        R value = f0.apply(f1.apply(project), u);
        if (value == null && profileId != null) {
            block0: for (MavenProject currentProject = project; value == null && currentProject != null; currentProject = currentProject.getParent()) {
                for (Profile profile : currentProject.getModel().getProfiles()) {
                    if (!profile.getId().equals(profileId)) continue;
                    value = f0.apply(f2.apply(profile), u);
                    continue block0;
                }
            }
        }
        return value;
    }

    private String optional(DependencyManagement mgmt, Dependency d) {
        if (mgmt != null) {
            return mgmt.getDependencies().stream().filter(it -> it.getGroupId().equals(d.getGroupId()) && it.getArtifactId().equals(d.getArtifactId())).findFirst().map(Dependency::getOptional).orElse(null);
        }
        return null;
    }

    private String scope(DependencyManagement mgmt, Dependency d) {
        if (mgmt != null) {
            return mgmt.getDependencies().stream().filter(it -> it.getGroupId().equals(d.getGroupId()) && it.getArtifactId().equals(d.getArtifactId())).findFirst().map(Dependency::getScope).orElse(null);
        }
        return null;
    }

    private String version(DependencyManagement mgmt, Dependency d) {
        if (mgmt != null) {
            return mgmt.getDependencies().stream().filter(it -> it.getGroupId().equals(d.getGroupId()) && it.getArtifactId().equals(d.getArtifactId())).findFirst().map(Dependency::getVersion).orElse(null);
        }
        return null;
    }

    private String version(PluginManagement mgmt, Plugin p) {
        if (mgmt != null) {
            return mgmt.getPlugins().stream().filter(it -> it.getGroupId().equals(p.getGroupId()) && it.getArtifactId().equals(p.getArtifactId())).findFirst().map(Plugin::getVersion).orElse(null);
        }
        return null;
    }

    private RemoteRepository repository(Repository repo) {
        org.apache.maven.model.RepositoryPolicy snapshotPolicy;
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repo.getId(), repo.getLayout(), repo.getUrl());
        org.apache.maven.model.RepositoryPolicy releasePolicy = repo.getReleases();
        if (!(releasePolicy != null && releasePolicy.isEnabled() || this.includeSnapshots)) {
            return null;
        }
        if (releasePolicy != null) {
            String updatePolicy = releasePolicy.getUpdatePolicy();
            String checksumPolicy = releasePolicy.getChecksumPolicy();
            builder.setReleasePolicy(new RepositoryPolicy(releasePolicy.isEnabled(), Strings.isValid((String)updatePolicy) ? updatePolicy : "always", Strings.isValid((String)checksumPolicy) ? checksumPolicy : "ignore"));
        }
        if ((snapshotPolicy = repo.getSnapshots()) != null) {
            String updatePolicy = snapshotPolicy.getUpdatePolicy();
            String checksumPolicy = snapshotPolicy.getChecksumPolicy();
            builder.setSnapshotPolicy(new RepositoryPolicy(snapshotPolicy.isEnabled() && this.includeSnapshots, Strings.isValid((String)updatePolicy) ? updatePolicy : "always", Strings.isValid((String)checksumPolicy) ? checksumPolicy : "ignore"));
        }
        return builder.build();
    }

    private Set<RemoteRepository> repos(List<Repository> repositories, Set<RemoteRepository> initial) {
        HashSet<RemoteRepository> result = new HashSet<RemoteRepository>(initial);
        for (Repository repo : repositories) {
            RemoteRepository remote = this.repository(repo);
            if (remote == null) continue;
            result.add(remote);
        }
        return result;
    }

    private record ResolvableArtifacts(List<MavenArtifact> artifacts, Set<RemoteRepository> repos) {
    }
}

