/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.cli;

import io.helidon.build.common.logging.LogLevel;
import io.helidon.build.devloop.ProjectSupplier;
import io.helidon.build.devloop.maven.DevLoopBuildConfig;
import io.helidon.build.devloop.maven.MavenEnvironment;
import io.helidon.build.devloop.maven.MavenGoalReferenceResolver;
import io.helidon.build.devloop.maven.MavenProjectConfigCollector;
import io.helidon.build.devloop.maven.MavenProjectSupplier;
import io.helidon.build.devloop.mode.DevLoop;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.LifecycleMappingDelegate;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.lifecycle.internal.MojoExecutor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="dev", defaultPhase=LifecyclePhase.NONE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DevMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}", required=true)
    private File devProjectDir;
    @Parameter(defaultValue="false", property="dev.clean")
    private boolean clean;
    @Parameter(defaultValue="false", property="dev.terminalMode")
    private boolean terminalMode;
    @Parameter(property="dev.appJvmArgs")
    private String appJvmArgs;
    @Parameter(property="dev.appArgs")
    private String appArgs;
    @Parameter(defaultValue="false", property="dev.skip")
    private boolean skip;
    @Parameter
    private DevLoopBuildConfig devLoop;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private BuildPluginManager plugins;
    @Component
    private MojoExecutor mojoExecutor;
    @Component
    private MojoDescriptorCreator mojoDescriptorCreator;
    @Component
    private DefaultLifecycles defaultLifeCycles;
    @Component(hint="default")
    private LifecycleMappingDelegate standardDelegate;
    @Component
    private Map<String, LifecycleMappingDelegate> delegates;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution.");
            return;
        }
        try {
            MavenProjectConfigCollector.assertSupportedProject((MavenSession)this.session);
            if (this.terminalMode && this.getLog().isDebugEnabled()) {
                LogLevel.set((LogLevel)LogLevel.DEBUG);
            }
            DevLoopBuildConfig configuration = this.buildConfig(true);
            MavenProjectSupplier projectSupplier = new MavenProjectSupplier(configuration);
            List<String> jvmArgs = DevMojo.toList(this.appJvmArgs);
            List<String> args = DevMojo.toList(this.appArgs);
            Path dir = this.devProjectDir.toPath();
            DevLoop loop = new DevLoop(dir, (ProjectSupplier)projectSupplier, this.clean, this.terminalMode, jvmArgs, args, configuration);
            loop.start(Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error", e);
        }
    }

    DevLoopBuildConfig buildConfig(boolean resolve) throws Exception {
        DevLoopBuildConfig config = this.devLoop == null ? new DevLoopBuildConfig() : this.devLoop;
        config.validate();
        if (resolve) {
            MavenEnvironment env = new MavenEnvironment(this.project, this.session, this.mojoDescriptorCreator, this.defaultLifeCycles, this.standardDelegate, this.delegates, this.plugins, this.mojoExecutor);
            MavenGoalReferenceResolver resolver = new MavenGoalReferenceResolver(env);
            config.resolve(resolver);
        }
        return config;
    }

    private static List<String> toList(String args) {
        return args == null ? Collections.emptyList() : Arrays.asList(args.split(" "));
    }
}

