/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public class FileRequest
implements Comparable<FileRequest> {
    private final Path path;
    private final String relativePath;
    private final String fileName;
    private final String suffix;
    private final String lastModifiedYear;

    private FileRequest(Path path, String relativePath, String fileName, String suffix, String lastModifiedYear) {
        this.path = path;
        this.relativePath = relativePath;
        this.fileName = fileName;
        this.suffix = suffix;
        this.lastModifiedYear = lastModifiedYear;
    }

    public static FileRequest create(Path rootPath, String relativePath, String lastModifiedYear) {
        Path file = rootPath.resolve(relativePath);
        String fileName = file.getFileName().toString();
        String fileSuffix = FileRequest.fileSuffix(fileName);
        return new FileRequest(file, relativePath, fileName, fileSuffix, lastModifiedYear);
    }

    public static FileRequest create(String relativePath, String lastModifiedYear) {
        Path filePath = Paths.get(relativePath, new String[0]);
        String fileName = filePath.getFileName().toString();
        String fileSuffix = FileRequest.fileSuffix(fileName);
        return new FileRequest(filePath, relativePath, fileName, fileSuffix, lastModifiedYear);
    }

    static FileRequest create(String relativePath) {
        int i = relativePath.lastIndexOf(47);
        String fileName = i > -1 ? relativePath.substring(i + 1) : relativePath;
        return new FileRequest(null, relativePath, fileName, FileRequest.fileSuffix(fileName), "2021");
    }

    private static String fileSuffix(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        return fileName.substring(index);
    }

    public Path path() {
        return this.path;
    }

    public String relativePath() {
        return this.relativePath;
    }

    public String fileName() {
        return this.fileName;
    }

    public String suffix() {
        return this.suffix;
    }

    public String lastModifiedYear() {
        return this.lastModifiedYear;
    }

    @Override
    public int compareTo(FileRequest o) {
        return this.relativePath.compareTo(o.relativePath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileRequest that = (FileRequest)o;
        return this.relativePath.equals(that.relativePath);
    }

    public int hashCode() {
        return Objects.hash(this.relativePath);
    }
}

