/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer;

import io.helidon.build.common.RichTextRenderer;
import io.helidon.build.common.ansi.AnsiTextStyle;
import io.helidon.build.maven.enforcer.EnforcerException;
import io.helidon.build.maven.enforcer.RuleFailure;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class FileSystem {
    private FileSystem() {
    }

    public static long size(Path path) {
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            throw new EnforcerException("Failed to get size of file " + path.toAbsolutePath(), e);
        }
    }

    public static List<String> toLines(Path path) {
        try {
            return Files.readAllLines(path, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new EnforcerException("Failed to read lines of file " + path.toAbsolutePath(), e);
        }
    }

    public static void write(Path path, String firstLine, Map<String, List<RuleFailure>> failures) {
        LinkedList<String> lines = new LinkedList<String>();
        lines.add(firstLine);
        failures.forEach((rule, ruleFails) -> {
            lines.add(rule.toUpperCase() + ":");
            ruleFails.stream().map(FileSystem::toFileLine).forEach(lines::add);
        });
        try {
            Files.write(path, lines, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new EnforcerException("Failed to write output file " + path.toAbsolutePath(), e);
        }
    }

    private static String toFileLine(RuleFailure failure) {
        return "[ERROR] " + failure.fr().relativePath() + ":" + failure.line() + ": " + AnsiTextStyle.strip((String)RichTextRenderer.render((String)failure.message()));
    }
}

