/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer.copyright;

import io.helidon.build.maven.enforcer.copyright.TemplateLine;
import io.helidon.build.maven.enforcer.copyright.Validator;
import io.helidon.build.maven.enforcer.copyright.ValidatorBase;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;

class ValidatorXml
extends ValidatorBase {
    private static final Optional<String> BLOCK_COMMENT_PREFIX = Optional.of("    ");

    protected ValidatorXml(Validator.ValidatorConfig validatorConfig, List<TemplateLine> templateLines) {
        super(validatorConfig, templateLines);
    }

    @Override
    public Set<String> supportedSuffixes() {
        return Set.of(".xml", ".xsl", ".html", ".xhtml", ".htm", ".dtd", ".xsd", ".wsdl", ".inc", ".jnlp", ".tld", ".xcs", ".jsf", ".hs", ".jhm");
    }

    @Override
    public boolean supports(Path path) {
        return path.getFileName().toString().equals("build.properties") && super.startsWith(path, "<");
    }

    @Override
    protected boolean supportsBlockComments() {
        return true;
    }

    @Override
    protected String blockCommentStart() {
        return "<!--";
    }

    @Override
    protected String blockCommentEnd() {
        return "-->";
    }

    @Override
    protected boolean allowLeadEmptyLine() {
        return true;
    }

    @Override
    protected boolean allowTrailEmptyLine(String modifiedYear) {
        return true;
    }

    @Override
    protected Optional<String> blockCommentPrefix() {
        return BLOCK_COMMENT_PREFIX;
    }

    @Override
    protected boolean copyrightBeforePreamble() {
        return false;
    }

    @Override
    protected boolean isPreamble(String line) {
        return line.startsWith("<?xml ") || line.startsWith("<!DOCTYPE") || line.startsWith("<html") || line.startsWith("<head>") || line.startsWith("<meta");
    }
}

