/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer;

import io.helidon.build.common.logging.Log;
import io.helidon.build.maven.enforcer.EnforcerException;
import io.helidon.build.maven.enforcer.FileFinder;
import io.helidon.build.maven.enforcer.FileSystem;
import io.helidon.build.maven.enforcer.FoundFiles;
import io.helidon.build.maven.enforcer.RuleFailure;
import io.helidon.build.maven.enforcer.copyright.Copyright;
import io.helidon.build.maven.enforcer.copyright.CopyrightConfig;
import io.helidon.build.maven.enforcer.inclusivenaming.InclusiveNamingRule;
import io.helidon.build.maven.enforcer.inclusivenaming.InlusiveNamingConfig;
import io.helidon.build.maven.enforcer.nativeimage.EnforcerNativeImageException;
import io.helidon.build.maven.enforcer.nativeimage.NativeImageConfig;
import io.helidon.build.maven.enforcer.nativeimage.NativeImageRule;
import io.helidon.build.maven.enforcer.typo.TypoConfig;
import io.helidon.build.maven.enforcer.typo.TyposRule;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="check", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class EnforcerMojo
extends AbstractMojo {
    @Parameter
    private CopyrightConfig copyrightConfig;
    @Parameter
    private TypoConfig typosConfig;
    @Parameter
    private NativeImageConfig nativeImageConfig;
    @Parameter
    private InlusiveNamingConfig inclusiveNamingConfig;
    @Parameter
    private File repositoryRoot;
    @Parameter(property="helidon.enforcer.use-git", defaultValue="true")
    private boolean useGit;
    @Parameter(property="helidon.enforcer.honor-gitignore", defaultValue="true")
    private boolean honorGitIgnore;
    @Parameter(property="helidon.enforcer.output.file")
    private File enforcerOutputFile;
    @Parameter(property="helidon.enforcer.failOnError", defaultValue="true")
    private boolean failOnError;
    @Parameter(property="helidon.enforcer.rules", defaultValue="copyright,typos")
    private String[] rules;
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    private File baseDirectory;
    @Parameter(defaultValue="false", property="helidon.enforcer.skip")
    private boolean skip;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path rootDir;
        if (this.skip) {
            Log.info((String)"Skipping execution.", (Object[])new Object[0]);
            return;
        }
        Path path = this.baseDirectory.toPath().toAbsolutePath();
        if (!path.equals(rootDir = Paths.get(this.session.getExecutionRootDirectory(), new String[0])) && path.startsWith(rootDir)) {
            Log.info((String)("Parent path " + rootDir + " already checked"), (Object[])new Object[0]);
            return;
        }
        if (this.rules.length == 0) {
            Log.info((String)"No rules enabled.", (Object[])new Object[0]);
            return;
        }
        FileFinder.Builder fileConfigBuilder = FileFinder.builder().useGit(this.useGit).honorGitIgnore(this.honorGitIgnore);
        if (this.repositoryRoot != null) {
            fileConfigBuilder.repositoryRoot(this.repositoryRoot.toPath());
        }
        FileFinder fileConfig = fileConfigBuilder.build();
        Log.verbose((String)("File config: " + fileConfig), (Object[])new Object[0]);
        FoundFiles filesToCheck = fileConfig.findFiles(this.baseDirectory.toPath());
        Log.verbose((String)("Discovered " + filesToCheck.fileRequests().size() + " files"), (Object[])new Object[0]);
        HashMap<String, List<RuleFailure>> failuresByRule = new HashMap<String, List<RuleFailure>>();
        HashMap<String, List<RuleFailure>> warningsByRule = new HashMap<String, List<RuleFailure>>();
        String[] stringArray = this.rules;
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String rule2;
            switch (rule2 = stringArray[i]) {
                case "copyright": {
                    this.runCopyright(filesToCheck, failuresByRule, warningsByRule);
                    continue block12;
                }
                case "typos": {
                    this.runTypos(filesToCheck, failuresByRule, warningsByRule);
                    continue block12;
                }
                case "native-image": {
                    this.runNativeImage(failuresByRule, warningsByRule);
                    continue block12;
                }
                case "inclusive-naming": {
                    this.runInclusiveNaming(filesToCheck, failuresByRule, warningsByRule);
                    continue block12;
                }
                default: {
                    throw new MojoExecutionException("Unsupported rule defined: " + rule2);
                }
            }
        }
        if (this.enforcerOutputFile != null) {
            Path enforcerOutputPath = this.enforcerOutputFile.toPath();
            if (warningsByRule.isEmpty()) {
                FileSystem.write(enforcerOutputPath, "ENFORCER OK", Map.of());
            } else {
                FileSystem.write(enforcerOutputPath, "ENFORCER ERROR", warningsByRule);
            }
        }
        if (!failuresByRule.isEmpty()) {
            Log.info((String)"-- $(MAGENTA enforcer results)", (Object[])new Object[0]);
            failuresByRule.forEach((rule, failures) -> {
                Log.error((String)("Rule $(magenta " + rule + ") failed. Errors:"), (Object[])new Object[0]);
                for (RuleFailure failure : failures) {
                    Log.error((String)failure.toString(), (Object[])new Object[0]);
                }
            });
            if (this.failOnError) {
                throw new MojoExecutionException("Failed to validate rules: " + String.join((CharSequence)(", " + failuresByRule.keySet()), new CharSequence[0]));
            }
            Log.warn((String)"Plugin is configured not to fail on error", (Object[])new Object[0]);
        }
    }

    private void runNativeImage(Map<String, List<RuleFailure>> failuresByRule, Map<String, List<RuleFailure>> warningsByRule) throws MojoFailureException {
        List<RuleFailure> errors;
        Log.info((String)"-- native image rule", (Object[])new Object[0]);
        Log.verbose((String)("Native Image config: " + this.nativeImageConfig), (Object[])new Object[0]);
        NativeImageRule rule = new NativeImageRule(this.nativeImageConfig);
        try {
            errors = rule.check();
        }
        catch (EnforcerNativeImageException e) {
            throw new MojoFailureException("Failed to validate native image", (Throwable)e);
        }
        if (!errors.isEmpty()) {
            warningsByRule.put("native-image", errors);
            if (this.nativeImageConfig.failOnError()) {
                failuresByRule.put("native-image", errors);
            } else {
                for (RuleFailure error : errors) {
                    Log.warn((String)error.toString(), (Object[])new Object[0]);
                }
            }
        }
    }

    private void runInclusiveNaming(FoundFiles filesToCheck, Map<String, List<RuleFailure>> failuresByRule, Map<String, List<RuleFailure>> warningsByRule) throws MojoFailureException {
        List<RuleFailure> errors;
        Log.info((String)"-- inclusive naming rule", (Object[])new Object[0]);
        Log.verbose((String)("Inclusive naming config: " + this.inclusiveNamingConfig), (Object[])new Object[0]);
        InclusiveNamingRule rule = InclusiveNamingRule.builder().config(this.inclusiveNamingConfig).build();
        try {
            errors = rule.check(filesToCheck);
        }
        catch (EnforcerException e) {
            throw new MojoFailureException("Failed to validate inclusive naming", (Throwable)e);
        }
        if (!errors.isEmpty()) {
            warningsByRule.put("inclusiveNaming", errors);
            if (this.inclusiveNamingConfig.failOnError()) {
                failuresByRule.put("inclusiveNaming", errors);
            } else {
                for (RuleFailure error : errors) {
                    Log.warn((String)error.toString(), (Object[])new Object[0]);
                }
            }
        }
    }

    private void runTypos(FoundFiles filesToCheck, Map<String, List<RuleFailure>> failuresByRule, Map<String, List<RuleFailure>> warningsByRule) throws MojoFailureException {
        List<RuleFailure> errors;
        Log.info((String)"-- typos rule", (Object[])new Object[0]);
        Log.verbose((String)("Typos config: " + this.typosConfig), (Object[])new Object[0]);
        TyposRule typoRule = TyposRule.builder().config(this.typosConfig).build();
        try {
            errors = typoRule.check(filesToCheck);
        }
        catch (EnforcerException e) {
            throw new MojoFailureException("Failed to validate typos", (Throwable)e);
        }
        if (!errors.isEmpty()) {
            warningsByRule.put("typos", errors);
            if (this.typosConfig.failOnError()) {
                failuresByRule.put("typos", errors);
            } else {
                for (RuleFailure error : errors) {
                    Log.warn((String)error.toString(), (Object[])new Object[0]);
                }
            }
        }
    }

    private void runCopyright(FoundFiles filesToCheck, Map<String, List<RuleFailure>> failuresByRule, Map<String, List<RuleFailure>> warningsByRule) throws MojoFailureException {
        List<RuleFailure> errors;
        Log.info((String)"-- copyright rule", (Object[])new Object[0]);
        Log.verbose((String)("Copyright config: " + this.copyrightConfig), (Object[])new Object[0]);
        Copyright.Builder copyrightBuilder = Copyright.builder().config(this.copyrightConfig);
        Copyright copyright = copyrightBuilder.build();
        try {
            errors = copyright.check(filesToCheck);
        }
        catch (EnforcerException e) {
            throw new MojoFailureException("Failed to validate copyright", (Throwable)e);
        }
        if (!errors.isEmpty()) {
            warningsByRule.put("copyright", errors);
            if (this.copyrightConfig.failOnError()) {
                failuresByRule.put("copyright", errors);
            } else {
                for (RuleFailure error : errors) {
                    Log.warn((String)error.toString(), (Object[])new Object[0]);
                }
            }
        }
    }
}

