/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer;

import io.helidon.build.maven.enforcer.FileRequest;
import java.util.List;

public interface FileMatcher {
    public static List<FileMatcher> create(String pattern) {
        if (pattern.startsWith(".") && !pattern.endsWith("/")) {
            return List.of(new SuffixMatcher(pattern), new NameMatcher(pattern));
        }
        if (pattern.startsWith("*.")) {
            return List.of(new SuffixMatcher(pattern.substring(1)));
        }
        if (pattern.startsWith("/")) {
            return List.of(new StartsWithMatcher(pattern.substring(1)));
        }
        if (pattern.endsWith("/")) {
            return List.of(new DirectoryMatcher(pattern));
        }
        if (pattern.contains(".") && !pattern.contains("/")) {
            return List.of(new NameMatcher(pattern));
        }
        return List.of(new ContainsMatcher(pattern));
    }

    public boolean matches(FileRequest var1);

    public static class SuffixMatcher
    implements FileMatcher {
        private final String suffix;

        SuffixMatcher(String suffix) {
            this.suffix = suffix;
        }

        public static SuffixMatcher create(String suffix) {
            return new SuffixMatcher(suffix);
        }

        @Override
        public boolean matches(FileRequest file) {
            return file.suffix().equals(this.suffix);
        }
    }

    public static class NameMatcher
    implements FileMatcher {
        private final String name;

        NameMatcher(String name) {
            this.name = name;
        }

        public static NameMatcher create(String name) {
            return new NameMatcher(name);
        }

        @Override
        public boolean matches(FileRequest file) {
            return file.fileName().equals(this.name);
        }
    }

    public static class StartsWithMatcher
    implements FileMatcher {
        private final String pattern;

        StartsWithMatcher(String pattern) {
            this.pattern = pattern;
        }

        public static StartsWithMatcher create(String startsWith) {
            return new StartsWithMatcher(startsWith);
        }

        @Override
        public boolean matches(FileRequest file) {
            return file.relativePath().startsWith(this.pattern);
        }
    }

    public static class DirectoryMatcher
    implements FileMatcher {
        private final ContainsMatcher contains;
        private final StartsWithMatcher startWith;

        DirectoryMatcher(String directory) {
            this.contains = new ContainsMatcher("/" + directory);
            this.startWith = new StartsWithMatcher(directory);
        }

        public static DirectoryMatcher create(String directoryString) {
            return new DirectoryMatcher(directoryString);
        }

        @Override
        public boolean matches(FileRequest file) {
            return this.contains.matches(file) || this.startWith.matches(file);
        }
    }

    public static class ContainsMatcher
    implements FileMatcher {
        private final String contains;

        ContainsMatcher(String contains) {
            this.contains = contains;
        }

        public static ContainsMatcher create(String contains) {
            return new ContainsMatcher(contains);
        }

        @Override
        public boolean matches(FileRequest file) {
            return file.relativePath().contains(this.contains);
        }
    }
}

