/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer.copyright;

import io.helidon.build.common.logging.Log;
import io.helidon.build.common.logging.LogLevel;
import io.helidon.build.maven.enforcer.FileFinder;
import io.helidon.build.maven.enforcer.RuleFailure;
import io.helidon.build.maven.enforcer.copyright.Copyright;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) {
        FileFinder.Builder filesBuilder = FileFinder.builder();
        Copyright.Builder copyrightBuilder = Copyright.builder();
        boolean verbose = false;
        boolean debug = false;
        Path baseDirectory = Paths.get(".", new String[0]).toAbsolutePath();
        block20: for (int optionIndex = 0; optionIndex < args.length; ++optionIndex) {
            String option = args[optionIndex];
            switch (option) {
                case "-C": {
                    String templatePath = Main.nextArg("-C", ++optionIndex, args, "Copyright template path");
                    copyrightBuilder.templateFile(Paths.get(templatePath, new String[0]));
                    continue block20;
                }
                case "-X": {
                    String excludeFile = Main.nextArg("-X", ++optionIndex, args, "Copyright matches file path");
                    copyrightBuilder.excludesFile(Paths.get(excludeFile, new String[0]));
                    continue block20;
                }
                case "-Y": {
                    String yearSeparator = Main.nextArg("-Y", ++optionIndex, args, "year separator");
                    copyrightBuilder.yearSeparator(yearSeparator);
                    continue block20;
                }
                case "-G": {
                    filesBuilder.useGit(false);
                    continue block20;
                }
                case "-v": {
                    verbose = true;
                    continue block20;
                }
                case "-d": {
                    debug = true;
                    continue block20;
                }
                case "--help": 
                case "-h": 
                case "/?": {
                    Main.help();
                    return;
                }
                default: {
                    if (option.startsWith("-")) {
                        Main.unknownOption(option);
                    }
                    if (optionIndex == args.length - 1) {
                        baseDirectory = Paths.get(option, new String[0]).toAbsolutePath();
                        continue block20;
                    }
                    Main.unknownOption(option);
                }
            }
        }
        if (debug) {
            LogLevel.set((LogLevel)LogLevel.DEBUG);
        } else if (verbose) {
            LogLevel.set((LogLevel)LogLevel.VERBOSE);
        }
        Copyright copyright = copyrightBuilder.build();
        List<RuleFailure> errors = copyright.check(filesBuilder.build().findFiles(baseDirectory));
        if (errors.isEmpty()) {
            Log.info((String)"Copyright OK", (Object[])new Object[0]);
            return;
        }
        Log.error((String)("Copyright failures (" + errors.size() + "):"), (Object[])new Object[0]);
        for (RuleFailure failure : errors) {
            Log.error((String)(failure.fr().relativePath() + ":" + failure.line() + " " + failure.message()), (Object[])new Object[0]);
        }
        System.exit(147);
    }

    private static void unknownOption(String option) {
        System.err.println("Unknown option " + option);
        Main.help();
        System.exit(12);
    }

    private static void help() {
        System.out.println("Usage: copyright [options] directory?");
        System.out.println("Options:");
        Main.helpOption("-C", "path", "Copyright template file path");
        Main.helpOption("-X", "path", "Copyright excludes file path");
        Main.helpOption("-Y", "text", "Year separator in copyright statement");
        Main.helpOption("-G", "Do not use git, only with -a");
        Main.helpOption("-d", "Enable debug output");
        Main.helpOption("-v", "Enable verbose output (less than debug)");
        Main.helpOption("-h", "Print this help information");
    }

    private static void helpOption(String flag, String description) {
        System.out.println("  " + flag + "        " + description);
    }

    private static void helpOption(String flag, String value, String description) {
        String filler = " ".repeat(7 - value.length());
        System.out.println("  " + flag + " " + value + filler + description);
    }

    private static String nextArg(String flag, int index, String[] args, String description) {
        if (args.length <= index) {
            System.err.println("Option " + flag + " requires a value: " + description);
            System.exit(13);
        }
        return args[index];
    }
}

