/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer;

import io.helidon.build.common.Strings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public class FileRequest
implements Comparable<FileRequest> {
    private final Path path;
    private final String relativePath;
    private final String fileName;
    private final String suffix;
    private final String lastModifiedYear;

    public String toString() {
        return "FileRequest{path=" + this.path + ", relativePath='" + this.relativePath + "', fileName='" + this.fileName + "', suffix='" + this.suffix + "', lastModifiedYear='" + this.lastModifiedYear + "'}";
    }

    private FileRequest(Path path, String relativePath, String fileName, String suffix, String lastModifiedYear) {
        this.path = path;
        this.relativePath = relativePath;
        this.fileName = fileName;
        this.suffix = suffix;
        this.lastModifiedYear = lastModifiedYear;
    }

    public static FileRequest create(Path rootPath, String relativePath, String lastModifiedYear) {
        String normPath = Strings.normalizePath((Object)relativePath);
        Path file = rootPath.resolve(normPath);
        String fileName = file.getFileName().toString();
        String fileSuffix = FileRequest.fileSuffix(fileName);
        return new FileRequest(file, normPath, fileName, fileSuffix, lastModifiedYear);
    }

    public static FileRequest create(String relativePath, String lastModifiedYear) {
        String normPath = Strings.normalizePath((Object)relativePath);
        Path filePath = Paths.get(normPath, new String[0]);
        String fileName = filePath.getFileName().toString();
        String fileSuffix = FileRequest.fileSuffix(fileName);
        return new FileRequest(filePath, normPath, fileName, fileSuffix, lastModifiedYear);
    }

    static FileRequest create(String relativePath) {
        int i = relativePath.lastIndexOf(47);
        String fileName = i > -1 ? relativePath.substring(i + 1) : relativePath;
        return new FileRequest(null, relativePath, fileName, FileRequest.fileSuffix(fileName), "2021");
    }

    private static String fileSuffix(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        return fileName.substring(index);
    }

    public Path path() {
        return this.path;
    }

    public String relativePath() {
        return this.relativePath;
    }

    public String fileName() {
        return this.fileName;
    }

    public String suffix() {
        return this.suffix;
    }

    public String lastModifiedYear() {
        return this.lastModifiedYear;
    }

    @Override
    public int compareTo(FileRequest o) {
        return this.relativePath.compareTo(o.relativePath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileRequest that = (FileRequest)o;
        return this.relativePath.equals(that.relativePath);
    }

    public int hashCode() {
        return Objects.hash(this.relativePath);
    }
}

