/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer.copyright;

import io.helidon.build.common.logging.Log;
import io.helidon.build.maven.enforcer.EnforcerException;
import io.helidon.build.maven.enforcer.FileMatcher;
import io.helidon.build.maven.enforcer.FileRequest;
import io.helidon.build.maven.enforcer.FileSystem;
import io.helidon.build.maven.enforcer.FoundFiles;
import io.helidon.build.maven.enforcer.RuleFailure;
import io.helidon.build.maven.enforcer.RuleFailureException;
import io.helidon.build.maven.enforcer.copyright.CopyrightConfig;
import io.helidon.build.maven.enforcer.copyright.TemplateLine;
import io.helidon.build.maven.enforcer.copyright.Validator;
import io.helidon.build.maven.enforcer.copyright.ValidatorAsciidoc;
import io.helidon.build.maven.enforcer.copyright.ValidatorBat;
import io.helidon.build.maven.enforcer.copyright.ValidatorHandlebars;
import io.helidon.build.maven.enforcer.copyright.ValidatorJava;
import io.helidon.build.maven.enforcer.copyright.ValidatorJsp;
import io.helidon.build.maven.enforcer.copyright.ValidatorProperties;
import io.helidon.build.maven.enforcer.copyright.ValidatorText;
import io.helidon.build.maven.enforcer.copyright.ValidatorXml;
import io.helidon.build.maven.enforcer.copyright.spi.ValidatorProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public class Copyright {
    private final Map<String, Validator> suffixToValidator = new HashMap<String, Validator>();
    private final List<Validator> allValidators = new LinkedList<Validator>();
    private final List<FileMatcher> excludes;
    private final Validator textValidator;

    private Copyright(Builder builder) {
        this.excludes = builder.excludes;
        ServiceLoader<ValidatorProvider> loader = ServiceLoader.load(ValidatorProvider.class);
        for (ValidatorProvider validatorProvider : loader) {
            Validator validator = validatorProvider.validator(builder.validatorConfig, builder.templateLines);
            this.allValidators.add(validator);
            for (String suffix : validator.supportedSuffixes()) {
                this.suffixToValidator.putIfAbsent(suffix, validator);
            }
        }
        LinkedList<Validator> builtIns = new LinkedList<Validator>();
        builtIns.add(new ValidatorJava(builder.validatorConfig, builder.templateLines));
        builtIns.add(new ValidatorProperties(builder.validatorConfig, builder.templateLines));
        builtIns.add(new ValidatorXml(builder.validatorConfig, builder.templateLines));
        builtIns.add(new ValidatorAsciidoc(builder.validatorConfig, builder.templateLines));
        builtIns.add(new ValidatorBat(builder.validatorConfig, builder.templateLines));
        builtIns.add(new ValidatorJsp(builder.validatorConfig, builder.templateLines));
        builtIns.add(new ValidatorHandlebars(builder.validatorConfig, builder.templateLines));
        this.textValidator = new ValidatorText(builder.validatorConfig, builder.templateLines);
        builtIns.add(this.textValidator);
        for (Validator validator : builtIns) {
            this.allValidators.add(validator);
            for (String suffix : validator.supportedSuffixes()) {
                this.suffixToValidator.putIfAbsent(suffix, validator);
            }
        }
    }

    static String logGood(String good) {
        return "\"$(GREEN " + good.replace(")", "\\)") + ")\"";
    }

    static String logBad(String bad) {
        return "\"$(YELLOW " + bad.replace(")", "\\)") + ")\"";
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<RuleFailure> check(FoundFiles files) {
        Log.info((String)("Obtaining last modified year for up to " + files.fileRequests().size() + " files"), (Object[])new Object[0]);
        List<FileRequest> validPaths = this.findFilesToCheck(files);
        LinkedList<RuleFailure> failures = new LinkedList<RuleFailure>();
        for (FileRequest fileRequest : validPaths) {
            this.checkCopyright(fileRequest, failures);
        }
        return failures;
    }

    private void checkCopyright(FileRequest file, List<RuleFailure> messages) {
        Path path = file.path();
        String relativePath = file.relativePath();
        if (!Files.isReadable(path)) {
            messages.add(RuleFailure.create(file, -1, "not readable"));
            return;
        }
        if (FileSystem.size(path) == 0L) {
            Log.debug((String)(relativePath + ": ignoring empty file"), (Object[])new Object[0]);
            return;
        }
        Validator validator = this.suffixToValidator.get(file.suffix());
        if (validator == null) {
            for (Validator candidate : this.allValidators) {
                if (!candidate.supports(path)) continue;
                validator = candidate;
                break;
            }
        }
        if (validator == null) {
            Log.debug((String)(relativePath + ": using fallback text validator."), (Object[])new Object[0]);
            validator = this.textValidator;
        }
        Log.verbose((String)(relativePath + " checking copyright with " + validator.getClass().getName()), (Object[])new Object[0]);
        try {
            validator.validate(file, path);
        }
        catch (RuleFailureException e) {
            messages.add(e.failure());
        }
    }

    private List<FileRequest> findFilesToCheck(FoundFiles files) {
        LinkedList<FileRequest> validPaths = new LinkedList<FileRequest>();
        for (FileRequest fileRequest : files.fileRequests()) {
            this.addValidFile(fileRequest, validPaths);
        }
        return validPaths;
    }

    private void addValidFile(FileRequest file, List<FileRequest> validPaths) {
        for (FileMatcher exclude : this.excludes) {
            if (!exclude.matches(file)) continue;
            Log.debug((String)("Excluding " + file.relativePath()), (Object[])new Object[0]);
            return;
        }
        Log.debug((String)("Including " + file.relativePath() + " with modified year (" + file.lastModifiedYear() + ")"), (Object[])new Object[0]);
        validPaths.add(file);
    }

    public static class Builder {
        private static final DateTimeFormatter YEAR_FORMATTER = DateTimeFormatter.ofPattern("yyyy");
        private final String currentYear = YEAR_FORMATTER.format(ZonedDateTime.now());
        private final Validator.ValidatorConfig.Builder validatorConfigBuilder = Validator.ValidatorConfig.builder();
        private String yearSeparator = ", ";
        private Path excludesFile;
        private Path templateFile;
        private List<FileMatcher> excludes;
        private Validator.ValidatorConfig validatorConfig;
        private List<TemplateLine> templateLines;

        private Builder() {
        }

        public Copyright build() {
            this.validatorConfig = this.validatorConfigBuilder.yearSeparator(this.yearSeparator).currentYear(this.currentYear).build();
            if (this.templateFile == null) {
                Log.verbose((String)"Parsing default template file (Apache 2).", (Object[])new Object[0]);
                this.templateLines = TemplateLine.parseTemplate(this.validatorConfig, this.defaultCopyrightTemplate());
            } else {
                Log.verbose((String)("Parsing template file: " + this.templateFile.toAbsolutePath()), (Object[])new Object[0]);
                this.templateLines = TemplateLine.parseTemplate(this.validatorConfig, FileSystem.toLines(this.templateFile));
            }
            this.excludes = this.parseExcludes();
            return new Copyright(this);
        }

        public Builder config(CopyrightConfig config) {
            config.excludeFile().map(File::toPath).ifPresent(this::excludesFile);
            config.templateFile().map(File::toPath).ifPresent(this::templateFile);
            config.yearSeparator().ifPresent(this::yearSeparator);
            return this;
        }

        public Builder excludesFile(Path excludesFile) {
            this.excludesFile = excludesFile;
            return this;
        }

        public Builder templateFile(Path templateFile) {
            this.templateFile = templateFile;
            return this;
        }

        public Builder yearSeparator(String yearSeparator) {
            this.yearSeparator = yearSeparator;
            return this;
        }

        private List<String> defaultCopyrightTemplate() {
            InputStream is = Copyright.class.getResourceAsStream("apache.txt");
            LinkedList<String> lines = new LinkedList<String>();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                String line;
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
            }
            catch (IOException e) {
                throw new EnforcerException("Failed to read default template from classpath");
            }
            return lines;
        }

        private List<FileMatcher> parseExcludes() {
            if (this.excludesFile == null) {
                return List.of();
            }
            try {
                Log.verbose((String)("Parsing matches file: " + this.excludesFile.toAbsolutePath()), (Object[])new Object[0]);
                return Files.readAllLines(this.excludesFile).stream().map(String::trim).filter(it -> !it.startsWith("#")).filter(it -> !it.isBlank()).map(FileMatcher::create).flatMap(Collection::stream).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw new EnforcerException("Failed to parse excludes file: " + this.excludesFile, e);
            }
        }
    }
}

