/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer.copyright;

import io.helidon.build.maven.enforcer.copyright.TemplateLine;
import io.helidon.build.maven.enforcer.copyright.Validator;
import io.helidon.build.maven.enforcer.copyright.ValidatorBase;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;

class ValidatorProperties
extends ValidatorBase {
    protected ValidatorProperties(Validator.ValidatorConfig validatorConfig, List<TemplateLine> templateLines) {
        super(validatorConfig, templateLines);
    }

    @Override
    public Set<String> supportedSuffixes() {
        return Set.of(".properties", ".prefs", ".py", ".sh", ".ksh");
    }

    @Override
    public boolean supports(Path path) {
        String fileName = path.getFileName().toString();
        if (fileName.startsWith("Makefile")) {
            return true;
        }
        if (fileName.startsWith("GNUmakefile")) {
            return true;
        }
        if (fileName.startsWith("Rakefile")) {
            return true;
        }
        if (fileName.startsWith("Dockerfile")) {
            return true;
        }
        if (fileName.equals("osgi.bundle")) {
            return true;
        }
        return this.startsWith(path, "#");
    }

    @Override
    protected boolean isPreamble(String line) {
        return line.startsWith("#!");
    }

    @Override
    protected boolean copyrightBeforePreamble() {
        return false;
    }

    @Override
    protected Optional<String> lineCommentStart() {
        return Optional.of("#");
    }
}

