/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer.copyright;

import io.helidon.build.common.logging.Log;
import io.helidon.build.maven.enforcer.FileRequest;
import io.helidon.build.maven.enforcer.copyright.TemplateLine;
import io.helidon.build.maven.enforcer.copyright.Validator;
import io.helidon.build.maven.enforcer.copyright.ValidatorBase;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;

class ValidatorJava
extends ValidatorBase {
    private static final Optional<String> BLOCK_COMMENT_PREFIX = Optional.of("*");

    protected ValidatorJava(Validator.ValidatorConfig validatorConfig, List<TemplateLine> templateLines) {
        super(validatorConfig, templateLines);
    }

    @Override
    public Set<String> supportedSuffixes() {
        return Set.of(".java", ".g", ".c", ".h", ".css", ".js");
    }

    @Override
    public boolean supports(Path path) {
        return super.startsWith(path, "/*\n");
    }

    @Override
    protected boolean supportsBlockComments() {
        return true;
    }

    @Override
    protected String blockCommentStart() {
        return "/*";
    }

    @Override
    protected String blockCommentEnd() {
        return "*/";
    }

    @Override
    protected Optional<String> blockCommentPrefix() {
        return BLOCK_COMMENT_PREFIX;
    }

    @Override
    protected boolean isPreamble(String line) {
        return line.startsWith("package ");
    }

    @Override
    protected boolean allowTrailEmptyLine(String modifiedYear) {
        return false;
    }

    @Override
    protected void containsTrailingEmptyLine(FileRequest file) {
        Log.warn((String)("File " + file.relativePath() + " contains trailing empty line in copyright comment."), (Object[])new Object[0]);
    }
}

