/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer.inclusivenaming;

import io.helidon.build.maven.enforcer.inclusivenaming.XmlData;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.Parameter;

public class InlusiveNamingConfig {
    @Parameter(defaultValue="false")
    private boolean failOnError;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter
    private String[] excludeTermsRegExps;
    @Parameter
    private XmlData[] additionalTerms;
    @Parameter
    private File inclusiveNamingFile;

    public String toString() {
        return "InlusiveNamingConfig{failOnError=" + this.failOnError + ", inclusiveNamingFile=" + this.inclusiveNamingFile + ", includes=" + Arrays.toString(this.includes) + ", excludes=" + Arrays.toString(this.excludes) + ", excludeTermsRegExps=" + Arrays.toString(this.excludeTermsRegExps) + ", additionalTerms=" + Arrays.toString(this.additionalTerms) + "}";
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    Set<String> excludes() {
        if (this.excludes == null) {
            return Set.of();
        }
        return Set.of(this.excludes);
    }

    Set<String> includes() {
        if (this.includes == null) {
            return Set.of();
        }
        return Set.of(this.includes);
    }

    Set<Pattern> excludeTermsRegExps() {
        if (this.excludeTermsRegExps == null) {
            return Set.of();
        }
        return Set.of(this.excludeTermsRegExps).stream().map(str -> Pattern.compile(str)).collect(Collectors.toSet());
    }

    Optional<File> inclusiveNamingFile() {
        return Optional.ofNullable(this.inclusiveNamingFile);
    }

    List<XmlData> additionalTerms() {
        if (this.additionalTerms == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.additionalTerms);
    }
}

