/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer.typo;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.Parameter;

public class TypoConfig {
    @Parameter(defaultValue="false")
    private boolean failOnError;
    @Parameter(required=true)
    private String[] typos;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;

    public boolean failOnError() {
        return this.failOnError;
    }

    public String toString() {
        return "TypoConfig{failOnError=" + this.failOnError + ", typos=" + Arrays.toString(this.typos) + ", includes=" + Arrays.toString(this.includes) + ", excludes=" + Arrays.toString(this.excludes) + "}";
    }

    Set<String> typos() {
        return Arrays.stream(this.typos).map(String::toLowerCase).collect(Collectors.toSet());
    }

    Set<String> excludes() {
        if (this.excludes == null) {
            return Set.of();
        }
        return Set.of(this.excludes);
    }

    Set<String> includes() {
        if (this.includes == null) {
            return Set.of();
        }
        return Set.of(this.includes);
    }
}

