/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer.typo;

import io.helidon.build.common.logging.Log;
import io.helidon.build.maven.enforcer.EnforcerException;
import io.helidon.build.maven.enforcer.FileMatcher;
import io.helidon.build.maven.enforcer.FileRequest;
import io.helidon.build.maven.enforcer.FoundFiles;
import io.helidon.build.maven.enforcer.RuleFailure;
import io.helidon.build.maven.enforcer.typo.TypoConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class TyposRule {
    private static final Set<String> DEFAULT_INCLUDES = Set.of(".java", ".xml", ".adoc", ".txt", ".md", ".html", ".css", ".properties", ".yaml", ".sh", ".sql", ".conf", ".json", ".kt", ".groovy", ".mustache", ".yml", ".graphql", ".proto", "Dockerfile.native", "Dockerfile.jlink", ".gradle", ".MF");
    private final Set<String> typos;
    private final List<FileMatcher> excludes;
    private final List<FileMatcher> includes;

    private TyposRule(Builder builder) {
        this.typos = builder.typosConfig.typos();
        this.excludes = builder.excludes();
        this.includes = builder.includes();
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<RuleFailure> check(FoundFiles filesToCheck) {
        LinkedList<RuleFailure> failures = new LinkedList<RuleFailure>();
        AtomicInteger count = new AtomicInteger();
        filesToCheck.fileRequests().stream().filter(this::include).forEach(fr -> {
            count.incrementAndGet();
            this.processFile((FileRequest)fr, (List<RuleFailure>)failures);
        });
        if (failures.size() == 0) {
            Log.info((String)("Typos processed " + count.get() + " files."), (Object[])new Object[0]);
        } else {
            Log.info((String)("Typos processed " + count.get() + " files, found " + failures.size() + " errors"), (Object[])new Object[0]);
        }
        return failures;
    }

    private void processFile(FileRequest fr, List<RuleFailure> errors) {
        try (BufferedReader bufferedReader = Files.newBufferedReader(fr.path(), StandardCharsets.UTF_8);){
            String line;
            int lineNum = 0;
            LinkedList<String> foundTypos = new LinkedList<String>();
            while ((line = bufferedReader.readLine()) != null) {
                ++lineNum;
                for (String typo : this.typos) {
                    if (!line.toLowerCase().contains(typo) || fr.fileName().equals("pom.xml") && line.toLowerCase().contains("<typo>" + typo + "</typo>")) continue;
                    foundTypos.add(typo);
                }
                if (!foundTypos.isEmpty()) {
                    errors.add(RuleFailure.create(fr, lineNum, "typos found: " + String.join((CharSequence)", ", foundTypos)));
                }
                foundTypos.clear();
            }
        }
        catch (IOException e) {
            throw new EnforcerException("Failed to process file for typos: " + fr.relativePath());
        }
    }

    private boolean include(FileRequest fr) {
        for (FileMatcher exclude : this.excludes) {
            if (!exclude.matches(fr)) continue;
            return false;
        }
        for (FileMatcher include : this.includes) {
            if (!include.matches(fr)) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        private TypoConfig typosConfig;

        private Builder() {
        }

        public Builder config(TypoConfig typosConfig) {
            this.typosConfig = typosConfig;
            return this;
        }

        public TyposRule build() {
            return new TyposRule(this);
        }

        List<FileMatcher> excludes() {
            return this.typosConfig.excludes().stream().map(FileMatcher::create).flatMap(Collection::stream).collect(Collectors.toList());
        }

        List<FileMatcher> includes() {
            HashSet<String> includes = new HashSet<String>(DEFAULT_INCLUDES);
            includes.addAll(this.typosConfig.includes());
            return includes.stream().map(FileMatcher::create).flatMap(Collection::stream).collect(Collectors.toList());
        }
    }
}

