/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer;

import io.helidon.build.maven.enforcer.EnforcerException;
import io.helidon.build.maven.enforcer.FileRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class GitCommands {
    private static final Pattern DATE_PATTERN = Pattern.compile("(\\d\\d\\d\\d)-\\d\\d-\\d\\d");

    private GitCommands() {
    }

    static Path repositoryRoot(Path checkPath) {
        Path path = Paths.get(GitCommands.singleLine(checkPath, "find git repository root", "rev-parse", "--show-toplevel"), new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new EnforcerException("Git root path does not exist: " + path.toAbsolutePath());
        }
        return path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Set<FileRequest> gitTracked(Path root, Path checkPath) {
        Process process = GitCommands.startProcess(root, "log", "--pretty=%cd", "--date=short", "--name-status", "--reverse");
        HashMap<String, Integer> fileToYear = new HashMap<String, Integer>();
        int lastYear = -1;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            block12: while ((line = reader.readLine()) != null) {
                if (line.isBlank()) continue;
                Matcher matcher = DATE_PATTERN.matcher(line);
                if (matcher.matches()) {
                    lastYear = Integer.parseInt(matcher.group(1));
                    continue;
                }
                if (lastYear == -1) {
                    throw new EnforcerException("Failed to parse output, expecting date to be present");
                }
                GitOperation gitOp = GitCommands.gitOp(line);
                String relativePath = GitCommands.stripGitOp(line);
                switch (gitOp) {
                    case DELETE: {
                        fileToYear.remove(relativePath);
                        continue block12;
                    }
                    case RENAME: {
                        GitCommands.rename(fileToYear, relativePath, lastYear);
                        continue block12;
                    }
                    case COPY: {
                        GitCommands.copy(fileToYear, relativePath, lastYear);
                        continue block12;
                    }
                }
                fileToYear.put(relativePath, lastYear);
            }
        }
        catch (IOException e) {
            throw new EnforcerException("Failed to read output when getting tracked files", e);
        }
        GitCommands.waitFor(process, String.valueOf(List.of()));
        LinkedList files = new LinkedList();
        fileToYear.forEach((found, year) -> files.add(FileRequest.create(root, found, String.valueOf(year))));
        String prefix = root.relativize(checkPath).toString();
        return files.stream().filter(fr -> fr.relativePath().startsWith(prefix)).collect(Collectors.toSet());
    }

    static Set<FileRequest> locallyModified(Path root, Path checkPath, String currentYear, List<Path> renamed) {
        Set<String> changedFiles = GitCommands.multiLine(root, "get locally modified files", s -> !s.startsWith("??") && !s.startsWith("D"), s -> {
            int firstSpace = s.indexOf(32);
            if (firstSpace < 0) {
                throw new EnforcerException("Cannot parse status line: " + s);
            }
            String fileLocation = s.substring(firstSpace).trim().replace('\\', '/');
            if (s.startsWith("R")) {
                int arrow = fileLocation.indexOf(" -> ");
                if (arrow < 0) {
                    throw new EnforcerException("Cannot parse renamed status line. " + s);
                }
                String oldName = fileLocation.substring(0, arrow).trim();
                renamed.add(Path.of(root.toString(), oldName));
                fileLocation = fileLocation.substring(arrow + 4).trim();
            }
            return fileLocation;
        }, "status", "-s");
        String prefix = root.relativize(checkPath).toString();
        return changedFiles.stream().filter(relativePath -> relativePath.startsWith(prefix)).map(relativePath -> FileRequest.create(root, relativePath, currentYear)).collect(Collectors.toSet());
    }

    private static void waitFor(Process process, String output) {
        try {
            int i = process.waitFor();
            if (i != 0) {
                throw new EnforcerException("Failed to find locally modified files, git exit code: " + i + ", process output: " + output);
            }
        }
        catch (InterruptedException ex) {
            throw new EnforcerException("Git process was interrupted", ex);
        }
    }

    private static Process startProcess(Path path, String ... command) {
        Process process;
        String[] allCommands = new String[command.length + 1];
        allCommands[0] = "git";
        System.arraycopy(command, 0, allCommands, 1, command.length);
        ProcessBuilder processBuilder = new ProcessBuilder(allCommands).redirectErrorStream(true).directory(path.toFile());
        try {
            process = processBuilder.start();
        }
        catch (IOException e) {
            throw new EnforcerException("Failed to start git process to find modified year", e);
        }
        try {
            process.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return process;
    }

    private static Set<String> multiLine(Path path, String message, Predicate<String> predicate, Function<String, String> mapper, String ... command) {
        Process process = GitCommands.startProcess(path, command);
        LinkedList<String> fullOutput = new LinkedList<String>();
        LinkedHashSet<String> wantedOutput = new LinkedHashSet<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                fullOutput.add(line);
                String trimmed = line.trim();
                if (!predicate.test(trimmed)) continue;
                wantedOutput.add(mapper.apply(trimmed));
            }
        }
        catch (IOException e) {
            throw new EnforcerException("Failed to read output to " + message, e);
        }
        GitCommands.waitFor(process, String.valueOf(fullOutput));
        return wantedOutput;
    }

    private static String singleLine(Path path, String message, String ... command) {
        Process process = GitCommands.startProcess(path, command);
        LinkedList<String> output = new LinkedList<String>();
        try {
            String string;
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            try {
                String line = reader.readLine();
                if (line == null) {
                    throw new EnforcerException("Failed to " + message + ", no output for command \"" + command + "\" in directory " + path.toAbsolutePath());
                }
                String trimmed = line.trim();
                output.add(trimmed);
                while ((line = reader.readLine()) != null) {
                    output.add(line);
                }
                if (trimmed.isBlank() || output.size() != 1) {
                    throw new EnforcerException("Failed to " + message + ", expected single line output for command \"" + command + "\" in directory " + path.toAbsolutePath() + ", but got: " + output);
                }
                string = trimmed;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new EnforcerException("Failed to read output of git process", e);
                }
            }
            reader.close();
            return string;
        }
        finally {
            GitCommands.waitFor(process, String.valueOf(output));
        }
    }

    private static void rename(Map<String, Integer> fileToYear, String relativePath, int lastYear) {
        int i = relativePath.indexOf(9);
        if (i < 0) {
            throw new EnforcerException("Failed to process renamed for path: " + relativePath);
        }
        String first = relativePath.substring(0, i).trim();
        String second = relativePath.substring(i + 1).trim();
        fileToYear.remove(first);
        fileToYear.put(second, lastYear);
    }

    private static void copy(Map<String, Integer> fileToYear, String relativePath, int lastYear) {
        int i = relativePath.indexOf(9);
        if (i < 0) {
            throw new EnforcerException("Failed to process copy for path: " + relativePath);
        }
        String second = relativePath.substring(i + 1).trim();
        fileToYear.put(second, lastYear);
    }

    private static String stripGitOp(String line) {
        int index = line.indexOf(9);
        if (index < 1) {
            throw new EnforcerException("Failed to strip git op for line " + line);
        }
        return line.substring(index).trim();
    }

    private static GitOperation gitOp(String line) {
        if (line.startsWith("A\t")) {
            return GitOperation.ADD;
        }
        if (line.startsWith("D\t")) {
            return GitOperation.DELETE;
        }
        if (line.startsWith("M\t")) {
            return GitOperation.MODIFY;
        }
        if (line.startsWith("C\t")) {
            return GitOperation.COPY;
        }
        if (line.startsWith("R")) {
            return GitOperation.RENAME;
        }
        throw new EnforcerException("Could not parse line " + line);
    }

    private static enum GitOperation {
        ADD,
        DELETE,
        MODIFY,
        RENAME,
        COPY;

    }
}

