/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer;

import io.helidon.build.common.Strings;
import io.helidon.build.common.logging.Log;
import io.helidon.build.maven.enforcer.FileMatcher;
import io.helidon.build.maven.enforcer.FileRequest;
import io.helidon.build.maven.enforcer.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

class GitIgnore
implements FileMatcher {
    private final List<Pattern> excludes = new LinkedList<Pattern>();
    private final List<Pattern> includes = new LinkedList<Pattern>();

    private GitIgnore() {
    }

    private void include(List<Pattern> pattern) {
        this.includes.addAll(pattern);
    }

    private void exclude(List<Pattern> pattern) {
        this.excludes.addAll(pattern);
    }

    static GitIgnore create(Path gitRepoDir) {
        GitIgnore ignore = new GitIgnore();
        Path gitIgnore = gitRepoDir.resolve(".gitignore");
        if (!Files.exists(gitIgnore, new LinkOption[0])) {
            return ignore;
        }
        FileSystem.toLines(gitIgnore).stream().filter(it -> !it.startsWith("#")).filter(it -> !it.isBlank()).forEach(ignore::parsePattern);
        return ignore;
    }

    static GitIgnore create(List<String> patterns) {
        GitIgnore ignore = new GitIgnore();
        patterns.forEach(ignore::parsePattern);
        return ignore;
    }

    private void parsePattern(String pattern) {
        if (pattern.startsWith("\\!")) {
            String exclude = pattern.substring(2);
            if (this.isParentExcluded(exclude)) {
                this.include(GitIgnore.create(exclude));
            }
            return;
        }
        this.exclude(GitIgnore.create(pattern));
    }

    private static List<Pattern> create(String pattern) {
        LinkedList<Pattern> patterns = new LinkedList<Pattern>();
        pattern = ((String)pattern).trim();
        if (((String)(pattern = ((String)pattern).replaceAll("\\?", "[^/]"))).contains("*")) {
            pattern = Pattern.compile("(^|[^*])\\*([^*]|$)").matcher((CharSequence)pattern).replaceAll(result -> result.group().replace("*", "([^/]*)"));
        }
        if (((String)pattern).contains("**")) {
            pattern = Pattern.compile("(^|[^*])\\*\\*([^*]|$)").matcher((CharSequence)pattern).replaceAll(result -> result.group().replace("**", "([^;]*)"));
        }
        if (((String)pattern).startsWith("/")) {
            pattern = ((String)pattern).replaceFirst("/", "/?");
        }
        if (((String)(pattern = ((String)pattern).replaceAll("\\.", "\\\\."))).endsWith("/")) {
            pattern = (String)pattern + "([^;]*)";
            patterns.add(Pattern.compile("([^;]*)/" + (String)pattern));
        }
        if (((String)pattern).contains("/([^;]*)/")) {
            patterns.add(Pattern.compile(((String)pattern).replaceAll("/\\(\\[\\^;]\\*\\)/", "/")));
        }
        if (((String)pattern).contains("([^;]*)/([^/]*)")) {
            patterns.add(Pattern.compile(((String)pattern).replaceAll("\\(\\[\\^;]\\*\\)/\\(\\[\\^/]\\*\\)", "([^/]+)")));
        }
        patterns.add(Pattern.compile((String)pattern));
        return patterns;
    }

    @Override
    public boolean matches(FileRequest file) {
        String path = file.relativePath();
        for (Pattern pattern : this.includes) {
            if (!pattern.matcher(path).matches()) continue;
            Log.debug((String)("Including " + path), (Object[])new Object[0]);
            return false;
        }
        for (Pattern pattern : this.excludes) {
            if (!pattern.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean isParentExcluded(String pattern) {
        String parent = Strings.normalizePath((Object)Path.of((String)(pattern = "/" + (String)pattern), new String[0]).getParent());
        if (!parent.endsWith("/")) {
            pattern = parent + "/";
        }
        for (Pattern exclude : this.excludes) {
            if (!exclude.matcher((CharSequence)pattern).matches()) continue;
            return false;
        }
        return true;
    }
}

